/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.spider;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;

class HttpControl {
    URI mStartpoint = null;
    URI mURI;

    HttpControl(URI uri) {
        this.mStartpoint = uri;
        this.init();
    }

    HttpControl(String s) {
        try {
            this.mStartpoint = new URI(s);
        }
        catch (Exception e) {
            this.logError(e.getMessage());
        }
        this.init();
    }

    void init() {
        try {
            if (!this.mStartpoint.isAbsolute()) {
                this.mStartpoint = new URI("http://localhost/bbbb/aaaa/index.asp").resolve(this.mStartpoint);
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage());
        }
    }

    public void setLink(URL url) {
        try {
            this.mURI = new URI(url.toExternalForm());
            if (!this.mURI.isAbsolute()) {
                this.mURI = this.mStartpoint.resolve(this.mURI);
            }
            this.showURLComponents(this.mURI.toURL());
        }
        catch (URISyntaxException e) {
            this.logError(e.getMessage());
        }
        catch (MalformedURLException e) {
            this.logError(e.getMessage());
        }
    }

    public String getLinkDirectory(URI uri) {
        String s = uri.toString();
        int i = -1;
        i = s.lastIndexOf("/");
        if (i != -1) {
            return s.substring(0, i + 1);
        }
        return null;
    }

    public String getLinkDirectory() {
        String s = this.mURI.toString();
        int i = -1;
        i = s.lastIndexOf("/");
        if (i != -1) {
            return s.substring(0, i + 1);
        }
        return null;
    }

    public void setLink(URI uri) {
        if (!uri.isAbsolute()) {
            uri = this.mStartpoint.resolve(uri);
        }
        this.mURI = uri;
        try {
            this.showURLComponents(this.mURI.toURL());
        }
        catch (MalformedURLException e) {
            this.logError(e.getMessage());
        }
    }

    public void logError(String s) {
        System.out.println(s);
    }

    public void showURLComponents(URL url) {
        System.out.println(url.getProtocol());
        System.out.println(url.getAuthority());
        System.out.println(url.getHost());
        System.out.println(url.getPort());
        System.out.println(url.getFile());
        System.out.println(url.getPath());
        System.out.println(url.getQuery());
        System.out.println(url.getRef());
        System.out.println(url.getUserInfo());
    }

    public String toString() {
        return this.mURI.toString();
    }

    public static void main(String[] args) {
        Vector<Serializable> vector = new Vector<Serializable>();
        try {
            vector.add(new URL("http://www.abc.com:80/abc/abcde?a=b&c=123#abc"));
            vector.add(new URL("http://archive.ncsa.uiuc.edu:8080/SDG/Software/Mosaic/Demo/url-primer.html#abc"));
            vector.add(new URI("../abc?a=b"));
            HttpControl control = new HttpControl("http://www.a.com/a111/b11/index.asp");
            int i = 0;
            while (i < vector.size()) {
                if (vector.elementAt(i) instanceof URI) {
                    control.setLink((URI)vector.elementAt(i));
                } else {
                    control.setLink((URL)vector.elementAt(i));
                }
                System.out.println(control);
                System.out.println(control.getLinkDirectory());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    class Cookie {
        String id;
        String value;
        String parameters;

        Cookie() {
        }

        public void setCookie(String header) {
            int i = header.indexOf(";");
        }
    }

    class Authentication {
        Vector mAuth;

        Authentication() {
        }
    }
}

