/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.spider;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

class UrlStack
extends Stack {
    private Vector UrlDone = new Vector();
    private Vector UrlRejected = new Vector();
    private String root = "/";

    UrlStack() {
    }

    public void setRoot(String s) {
        this.root = s;
        this.add(s);
    }

    public synchronized Object pop() {
        Object obj;
        try {
            while (this.UrlDone.indexOf((String)(obj = super.pop())) != -1) {
            }
            this.UrlDone.add((String)obj);
        }
        catch (EmptyStackException ese) {
            return null;
        }
        return obj;
    }

    public Vector getUrlDone() {
        return this.UrlDone;
    }

    public synchronized boolean pushUrlRejected(String s) {
        this.remove(s);
        if (this.UrlRejected.indexOf(s) == -1) {
            this.UrlRejected.add(s);
            return true;
        }
        return false;
    }

    public synchronized void pushUrlRejected(Vector s) {
        int i = 0;
        while (i < s.size()) {
            this.remove(s.elementAt(i));
            if (this.UrlRejected.indexOf(s.elementAt(i)) == -1) {
                if (s.elementAt(i) instanceof URI) {
                    this.UrlRejected.add(s.elementAt(i).toString());
                } else {
                    this.UrlRejected.add(s.elementAt(i));
                }
            }
            ++i;
        }
    }

    public synchronized boolean push2(String s) {
        String a;
        try {
            int index = 0;
            String query = null;
            index = s.indexOf("#");
            if (index != -1) {
                s = s.substring(0, index);
            }
            if ((index = s.indexOf("?")) != -1) {
                query = s.substring(index + 1);
                query = URLEncoder.encode(query, "8859_1");
                s = s.substring(0, index);
            }
            a = String.valueOf(new URI(s).normalize().getPath()) + (query != null ? "?" + query : "");
        }
        catch (UnsupportedEncodingException ie) {
            System.out.println("url error (unspported encoding)" + ie);
            return false;
        }
        catch (URISyntaxException ie) {
            System.out.println("url error " + s);
            ie.printStackTrace();
            return false;
        }
        if (!a.startsWith(this.root)) {
            this.UrlRejected.add(String.valueOf(a) + " (not under spider path)");
            return false;
        }
        if (this.UrlDone.indexOf(a) != -1 || this.UrlRejected.indexOf(a) != -1) {
            return false;
        }
        if (this.indexOf(a) != -1) {
            return false;
        }
        return super.add(a);
    }

    public synchronized boolean push(String s) {
        String a;
        URI uri = null;
        int index = 0;
        Object query = null;
        index = s.indexOf("#");
        if (index != -1) {
            s = s.substring(0, index);
        }
        try {
            uri = new URI(s);
            a = uri.toString();
        }
        catch (URISyntaxException ie) {
            System.out.println("url error " + s);
            ie.printStackTrace();
            return false;
        }
        if (this.UrlDone.indexOf(a) != -1 || this.UrlRejected.indexOf(a) != -1) {
            return false;
        }
        if (this.indexOf(a) != -1) {
            return false;
        }
        return super.add(a);
    }

    public synchronized boolean push(Vector s) {
        Enumeration e = s.elements();
        while (e.hasMoreElements()) {
            this.push((String)e.nextElement());
        }
        return true;
    }

    public synchronized boolean remove(String s) {
        return super.remove(s);
    }

    public void list() {
        Enumeration e = super.elements();
        while (e.hasMoreElements()) {
            System.out.println("list: " + (String)e.nextElement());
        }
    }

    public void listUrlDone() {
        System.out.println("\r\nURLs crawled: ");
        Enumeration e = this.UrlDone.elements();
        while (e.hasMoreElements()) {
            System.out.println("list: " + (String)e.nextElement());
        }
    }

    public String listUrlRejected() {
        String out = "URLs rejected: ";
        if (this.UrlRejected.size() == 0) {
            return String.valueOf(out) + "NONE\r\n";
        }
        out = String.valueOf(out) + "\r\n";
        Enumeration e = this.UrlRejected.elements();
        while (e.hasMoreElements()) {
            out = String.valueOf(out) + " - " + (String)e.nextElement() + "\r\n";
        }
        return out;
    }
}

