/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.ui;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.document.WebDoc;
import com.proofsecure.paros.document.WebDocExt;
import com.proofsecure.paros.document.WebLink;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileFilter;

public class OfflinePanel
extends JPanel {
    private WebDoc webDoc = null;
    private JTextArea jTextArea3 = new JTextArea();
    private JToggleButton toggleOffline = new JToggleButton();
    private JButton jButton5 = new JButton();
    private JButton jButton6 = new JButton();
    private JButton jButton7 = new JButton();
    private JButton jButton8 = new JButton();
    private JScrollPane jScrollPane7 = new JScrollPane();
    private JScrollPane jScrollPane10 = new JScrollPane();
    private Box box2;

    public OfflinePanel(WebDoc doc) {
        this.webDoc = doc;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.jTextArea3.setBackground(Color.LIGHT_GRAY);
        this.jTextArea3.setEditable(false);
        this.jTextArea3.setMargin(new Insets(2, 4, 2, 4));
        this.box2 = Box.createHorizontalBox();
        this.box2.add((Component)this.toggleOffline, null);
        this.box2.add((Component)this.jButton5, null);
        this.box2.add((Component)this.jButton6, null);
        this.box2.add((Component)this.jButton7, null);
        this.box2.add((Component)this.jButton8, null);
        this.add((Component)this.jScrollPane7, "Center");
        this.add((Component)this.jScrollPane10, "South");
        this.jScrollPane10.setVerticalScrollBarPolicy(21);
        this.jScrollPane10.setHorizontalScrollBarPolicy(31);
        this.jScrollPane10.getViewport().add((Component)this.box2, null);
        this.jScrollPane7.getViewport().add((Component)this.jTextArea3, null);
        this.toggleOffline.setText("Go Offline");
        this.toggleOffline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OfflinePanel.this.toggleOffline_actionPerformed(e);
            }
        });
        this.jButton5.setText("Clear Cache");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OfflinePanel.this.jButton5_actionPerformed(e);
            }
        });
        this.jButton6.setText("Save Cache");
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OfflinePanel.this.jButton6_actionPerformed(e);
            }
        });
        this.jButton7.setText("Load Cache");
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OfflinePanel.this.jButton7_actionPerformed(e);
            }
        });
        this.jButton8.setText("Show Comment");
        this.jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OfflinePanel.this.jButton8_actionPerformed(e);
            }
        });
    }

    public void setLogLink(WebLink w) {
        this.webDoc.setHistory(w);
    }

    public Object getLogLink(String host, String s) {
        return this.webDoc.getHistory(host, s);
    }

    public Object getLogLink(String host, String s, String post) {
        return this.webDoc.getHistory(host, s, post);
    }

    void toggleOffline_actionPerformed(ActionEvent e) {
        if (this.toggleOffline.getText().equals("Go Offline")) {
            Global.isOffline = true;
            this.toggleOffline.setText("Go Online");
        } else {
            Global.isOffline = false;
            this.toggleOffline.setText("Go Offline");
        }
    }

    void jButton5_actionPerformed(ActionEvent e) {
        this.webDoc = new WebDoc();
        Global.parosFrame.clearTree();
        this.jTextArea3.setText("");
    }

    void jButton6_actionPerformed(ActionEvent e) {
        try {
            String filename = String.valueOf(File.separator) + "par";
            JFileChooser fc = new JFileChooser(new File(filename));
            fc.addChoosableFileFilter(new MyFilter());
            fc.showSaveDialog(this);
            File selFile = fc.getSelectedFile();
            if (selFile == null) {
                return;
            }
            filename = selFile.getPath();
            if (filename.indexOf(".par") == -1) {
                filename = String.valueOf(filename) + ".par";
            }
            ObjectOutputStream x = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename))));
            x.writeObject(this.webDoc);
            x.close();
        }
        catch (IOException ae) {
            System.out.println("File not found.");
        }
    }

    void jButton7_actionPerformed(ActionEvent e) {
        try {
            String filename = String.valueOf(File.separator) + "par";
            JFileChooser fc = new JFileChooser(new File(filename));
            fc.addChoosableFileFilter(new MyFilter());
            fc.showOpenDialog(this);
            File selFile = fc.getSelectedFile();
            if (selFile == null) {
                return;
            }
            ObjectInputStream d = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(selFile))));
            this.webDoc = (WebDoc)d.readObject();
            String line1 = "Website Cache Information:\r\n\r\n";
            String links = this.webDoc.toString();
            StringTokenizer st = new StringTokenizer(links, "\r\n");
            while (st.hasMoreTokens()) {
                String l = st.nextToken();
                String respcode = "";
                int index = 0;
                index = l.indexOf(" ");
                if (index != -1) {
                    respcode = l.substring(0, index);
                    l = l.substring(index);
                }
                if ((index = l.indexOf("/")) == -1) continue;
                String host = l.substring(0, index);
                String uri = l.substring(index);
                Global.parosFrame.setTreeNoGUI(host, uri);
            }
            Global.parosFrame.refreshTree();
            this.jTextArea3.setText(String.valueOf(line1) + links);
        }
        catch (Exception ae) {
            JOptionPane.showMessageDialog(this, "Incompatible file format or file corrupted.");
        }
    }

    void jButton8_actionPerformed(ActionEvent e) {
        this.jTextArea3.setText(WebDocExt.toStringForComment(this.webDoc));
    }

    class MyFilter
    extends FileFilter {
        MyFilter() {
        }

        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".par");
        }

        public String getDescription() {
            return "*.par";
        }
    }
}

