/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.ui;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.ParsedFolder;
import com.proofsecure.paros.scan.ParsedURL;
import com.proofsecure.paros.ui.PopupPanel;
import com.proofsecure.paros.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TreePanel
extends JPanel {
    private ParsedEntity reqTreeRootNode = new ParsedEntity("Web Site Hierarchy");
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.reqTreeRootNode);
    private JTree reqTree = new JTree(this.treeModel);
    private JScrollPane jScrollPane2 = new JScrollPane();

    public TreePanel() {
        this.init();
    }

    private void init() {
        this.addTreeListener();
        this.setLayout(new BorderLayout());
        this.jScrollPane2.getViewport().add((Component)this.reqTree, null);
        this.add((Component)this.jScrollPane2, "Center");
    }

    public void init(JTree tree) {
        this.addTreeListener();
        this.setLayout(new BorderLayout());
        this.jScrollPane2.getViewport().add((Component)tree, null);
        this.add((Component)this.jScrollPane2, "Center");
    }

    public ParsedEntity getRoot() {
        return this.reqTreeRootNode;
    }

    public ParsedEntity getSelectedParsedEntity() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.reqTree.getLastSelectedPathComponent();
        return (ParsedEntity)node;
    }

    public Vector stringToToken(String s) {
        Vector<String> sVector = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(s, "/");
        if (s.startsWith("http://")) {
            tokens.nextToken();
            tokens.nextToken();
        }
        while (tokens.hasMoreTokens()) {
            String st = tokens.nextToken();
            sVector.add(st);
        }
        return sVector;
    }

    String textReplace(String hdr, String start, String end, String replace) {
        StringTokenizer st;
        int c1 = 0;
        c1 = hdr.indexOf(start);
        if (c1 != -1 && (st = new StringTokenizer(hdr.substring(c1 += start.length()), end)).hasMoreTokens()) {
            String l = st.nextToken();
            StringBuffer sb = new StringBuffer(hdr);
            sb.replace(c1, c1 + l.length(), replace);
            hdr = sb.toString();
        }
        return hdr;
    }

    public void addTreeListener() {
        this.reqTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    PopupPanel pp = new PopupPanel(TreePanel.this.reqTree);
                    pp.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else {
                    int selRow = TreePanel.this.reqTree.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = TreePanel.this.reqTree.getPathForLocation(e.getX(), e.getY());
                    if (selRow != -1) {
                        e.getClickCount();
                    }
                }
            }
        });
        this.reqTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)TreePanel.this.reqTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Global.parosFrame.getParosMenu().setMenuScanSkipDisplay((ParsedEntity)node);
            }
        });
    }

    public void TreeRefresh() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreePanel.this.reqTree.removeAll();
                TreePanel.this.reqTree = new JTree(TreePanel.this.reqTreeRootNode);
                TreePanel.this.addTreeListener();
                TreePanel.this.jScrollPane2.getViewport().add((Component)TreePanel.this.reqTree, null);
            }
        });
    }

    public void setTree(HttpRequestHeader req, HttpBody body) throws HttpMalformedHeaderException, URISyntaxException {
        this.addPath(req, body);
        this.TreeRefresh();
    }

    public void clearTree() {
        this.reqTree.removeAll();
        this.reqTreeRootNode = new ParsedEntity("Web Site Hierarchy");
        this.reqTree = new JTree(this.reqTreeRootNode);
        this.addTreeListener();
        this.jScrollPane2.getViewport().add((Component)this.reqTree, null);
    }

    private void addChild(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        this.treeModel.insertNodeInto(child, parent, parent.getChildCount());
    }

    private void removeChild(DefaultMutableTreeNode child) {
        this.treeModel.removeNodeFromParent(child);
    }

    public void addPath(HttpRequestHeader reqHeader, HttpBody reqBody) throws HttpMalformedHeaderException, URISyntaxException {
        ParsedURL parsedURL = new ParsedURL("", reqHeader, reqBody);
        URI uri = parsedURL.getURIHostPath();
        String absPath = uri.getPath();
        String baseUri = "";
        baseUri = String.valueOf(uri.getScheme()) + "://" + parsedURL.getHostName();
        if (parsedURL.getHostPort() != 80 && parsedURL.getHostPort() != 443) {
            baseUri = String.valueOf(baseUri) + ":" + parsedURL.getHostPort();
        }
        ParsedEntity parentEntity = null;
        ParsedEntity curEntity = null;
        ParsedEntity parsedEntity = this.reqTreeRootNode;
        synchronized (parsedEntity) {
            try {
                parentEntity = this.findChild(this.reqTreeRootNode, parsedURL.getHostName());
                if (parentEntity == null) {
                    parentEntity = new ParsedFolder(parsedURL.getHostName(), new URI(baseUri), parsedURL);
                    this.addChild(this.reqTreeRootNode, parentEntity);
                }
                Pattern pattern = Pattern.compile("/");
                String[] split = pattern.split(absPath);
                int i = 0;
                while (i < split.length) {
                    String path = split[i];
                    if (!path.equals("")) {
                        curEntity = this.findChild(parentEntity, path);
                        baseUri = String.valueOf(baseUri) + "/" + path;
                        if (curEntity == null) {
                            if (i < split.length - 1) {
                                curEntity = new ParsedFolder(path, new URI(baseUri), parsedURL);
                            } else {
                                parsedURL.setCaption(path);
                                curEntity = parsedURL;
                            }
                            this.addChild(parentEntity, curEntity);
                        } else if (i == split.length - 1) {
                            this.removeChild(curEntity);
                            this.addChild(parentEntity, curEntity);
                        }
                        parentEntity = curEntity;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addPath(ParsedEntity parsedURL) throws HttpMalformedHeaderException, URISyntaxException {
        URI uri = parsedURL.getURIHostPath();
        String absPath = uri.getPath();
        String baseUri = "";
        baseUri = String.valueOf(uri.getScheme()) + "://" + parsedURL.getHostName();
        if (parsedURL.getHostPort() != 80 && parsedURL.getHostPort() != 443) {
            baseUri = String.valueOf(baseUri) + ":" + parsedURL.getHostPort();
        }
        ParsedEntity parentEntity = null;
        ParsedEntity curEntity = null;
        ParsedEntity parsedEntity = this.reqTreeRootNode;
        synchronized (parsedEntity) {
            try {
                parentEntity = this.findChild(this.reqTreeRootNode, parsedURL.getHostName());
                if (parentEntity == null) {
                    parentEntity = new ParsedFolder(parsedURL.getHostName(), new URI(baseUri), parsedURL);
                    this.addChild(this.reqTreeRootNode, parentEntity);
                }
                Pattern pattern = Pattern.compile("/");
                String[] split = pattern.split(absPath);
                int i = 0;
                while (i < split.length) {
                    String path = split[i];
                    if (!path.equals("")) {
                        curEntity = this.findChild(parentEntity, path);
                        baseUri = String.valueOf(baseUri) + "/" + path;
                        if (curEntity == null) {
                            if (i < split.length - 1) {
                                curEntity = new ParsedFolder(path, new URI(baseUri), parsedURL);
                            } else {
                                parsedURL.setCaption(path);
                                curEntity = parsedURL;
                            }
                            this.addChild(parentEntity, curEntity);
                        } else if (i == split.length - 1) {
                            this.removeChild(curEntity);
                            this.addChild(parentEntity, curEntity);
                        }
                        parentEntity = curEntity;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ParsedEntity findChild(DefaultMutableTreeNode parent, String caption) {
        int i = 0;
        while (i < parent.getChildCount()) {
            ParsedEntity child = (ParsedEntity)parent.getChildAt(i);
            if (child.toString().equals(caption)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public void debugTraverseTreeRoot() {
        this.debugTraverseTree(this.reqTreeRootNode);
    }

    public void debugTraverseTree(DefaultMutableTreeNode node) {
        ParsedEntity en = null;
        if (node instanceof ParsedFolder) {
            en = (ParsedFolder)node;
            Util.showDebugMsg("Folder: " + en.getURIHostPath());
        } else if (node instanceof ParsedURL) {
            en = (ParsedURL)node;
            Util.showDebugMsg("URL: " + en.getURIHostPath());
        }
        int i = 0;
        while (i < node.getChildCount()) {
            this.debugTraverseTree((DefaultMutableTreeNode)node.getChildAt(i));
            ++i;
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public JTree getTree() {
        return this.reqTree;
    }
}

