/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros;

import java.io.File;

import javax.swing.DefaultListModel;

import com.proofsecure.paros.log.*;
import com.proofsecure.paros.network.SSLConnector;
import com.proofsecure.paros.ui.FindDialog;
import com.proofsecure.paros.ui.EncodeDialog;
import com.proofsecure.paros.ui.ParosFrame;
import com.proofsecure.paros.ui.TrapPanel;
import com.proofsecure.paros.ui.TreePanel;



public class Global {
	
	public final static Splash splash = new Splash();
	public final static String APP_NAME 		= "Paros";
	public final static String APP_VERSION		= "3.1.2";
	public final static String APP_EDITION		= "";
	public final static String APP_TITLE		= APP_NAME + " " + APP_VERSION + " " + APP_EDITION;
	public final static String DIR_PROJECT		= "project";
	public final static String DIR_REPORT		= "report";
	public final static String PATH_SCAN_REPORT = DIR_PROJECT + File.separator + "paros_scanning_report.htm";
	


	public static SSLConnector ssl 		= null;
  	public static com.proofsecure.paros.FilterManager filterManager = null;
  	public static com.proofsecure.paros.scan.ScanManager scanManager = null;
  	public static com.proofsecure.paros.util.Config config = null;
	public static Proxy   proxy   = null;
	public static SSLProxy	SSLProxy	= null;
	public static AdminServer adminServer = null;	
	public static ParosFrame	parosFrame = null;
	public static TreePanel	treePanel	= null;
	public static TrapPanel	trapPanel	= null;
	public static com.proofsecure.paros.scan.Scanner	scanner = null;
	public static com.proofsecure.paros.scan.AbstractScanner	currentScanner = null; 	
	public static com.proofsecure.paros.document.WebDoc webDoc =  null;
	public static FindDialog	findDialog 		= null;
	public static EncodeDialog	encodeDialog	= null;	
	public static Dump	dumpLog		= new Dump();
	public static DumpAnalyzerGUI dumpAnalyzer		= new DumpAnalyzerGUI(dumpLog);  	
	public static File			fileReportScan		= new File(PATH_SCAN_REPORT);
	public static	DefaultListModel	urlLog		= new DefaultListModel(); 
	
	// flags
	public static boolean		isOffline			= false;
	public static boolean		isUseClientCert		= false;
	public static boolean		isModifyUserAgent 	= true;
	public static boolean		isCmdTunnel			= false;
	public static boolean		isCmdSSLin			= false;
	public static boolean		isCmdSSLout			= false;
	public static String		cmdSourceHost		= "127.0.0.1";
	public static int			cmdSourcePort		= 8080;
	public static String		cmdHostName			= "";
  	public static int			cmdHostPort			= 80;
  	public static boolean		isViewImage			= false;
  	public static boolean		isRunGUI			= true;
	public static boolean		isDumpLog			= true;
	public static boolean		isDumpScan			= false;
	public static boolean		isRunAdminServer	= false;
	public static boolean		isReportEnabled		= true;
	public static boolean		isST				= false;

/*  	
  	static {
  		ssl = new SSLConnector();
  		ssl.init();
  	}
*/  	
  	public static String getEyeCatcher() {
  		if (isModifyUserAgent) {
  			return APP_NAME;
  		} else {
  			return "";
  		}
  	}
  	
  	
}
