/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.filter;

import javax.swing.JDialog;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;

/**
  Filter need to be implemented with thread-safe measures by developers themselves. 
  because only one Filter instance will be created by Paros.
  So, if application-wide share data is required, thread-safe issue need to be considered.
  
*/

public interface Filter {

  void process(HttpHeader header, HttpBody body);
  String usage();  // return the usage description
  JDialog getDialog();	// return the configuration Dialog if any, or return NULL
}

