/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.filter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;

// record all POST queries
// performance can be improved by:
// - use string.replace instead of Hashtable to parse parameter 
// - create threads to log queries to file 

public class LogPostQuery extends AbstractFilter{
  private final String logFile = "post.xls";
  private final String delim = "\t";    
  private final int MAX_FORM_FIELDS = 80;
  private File selFile;		    
  private Pattern pSeparator	= Pattern.compile("([^=&]+)[=]([^=&]*)"); 
  private Matcher matcher2;
  
  public LogPostQuery(){
	selFile = new File(logFile);
	dialog = new PDialog("LogPostQuery");
  }

  /**
  *   used by FilterManager to run the filter 
  *   @param    header      header to be filtered
  *   @param    body 				body to be filtered (no use here)
  */
  public void filterRequest(HttpRequestHeader reqHeader, HttpBody body){
    if (reqHeader != null && reqHeader.isText()){
		if (reqHeader.getMethod().equalsIgnoreCase(HttpRequestHeader.POST)){
			
//			String uri = reqheader.getAbsoluteURI();
			String uri = reqHeader.getURIHostPathQuery();

			String firstline = reqHeader.getHostName() + delim + reqHeader.getHostPort() + delim + uri; 

			Hashtable param = parseParameter(body.toString());

			// write to default file
			writeLogFile(firstline,param);
		
		}

    }

//    return header;//.toString();
  }
  
  public String usage(){
    return "Record all POST query into file " + logFile;
  }    
  
	private synchronized void writeLogFile(String line, Hashtable param){
				// write to default file
			    try{
			    
			    BufferedWriter out = new BufferedWriter(new FileWriter(selFile,true));
	
				out.write(line + "\r\n");
					
	    		Enumeration v = param.keys();
	 	        while (v.hasMoreElements()) {
			        String name = (String)v.nextElement();
			        String value = (String)param.get(name);
				    out.write(delim + name + delim + value + "\r\n");		        		           
			    }    		
	
			    out.close();    
			  
			    }catch(IOException ae){
			    }
			    
	}


	private Hashtable parseParameter(String param){
/*		
      int end = 0;
      int start = 0;
      int row =0, col=0;
	  String subStr;
	  String fieldname=null, value=null;
*/
	  Hashtable table = new Hashtable();

	  try{	  

		matcher2 = pSeparator.matcher(param);
		while (matcher2.find()){
			// start of a request
			table.put(matcher2.group(1), matcher2.group(2));
					
		}
/*		
	  // allow max. 80 form fields 
	      while (row< MAX_FORM_FIELDS  && (end=param.indexOf('=')) != -1){
	        // head
	        subStr = param.substring(start,end);
//	        fieldname = URLDecoder.decode(subStr,"8859_1");
			fieldname = subStr;
	        col++;
	        start=end+1;
	        param = param.substring(start,param.length());
	        start=0;
	        if ((end=param.indexOf('&'))!=-1){
	          subStr = param.substring(start,end);
//	          value = URLDecoder.decode(subStr,"8859_1");
			  value = subStr;
  			  table.put(fieldname, value);
	          row++;
	          col=0;
	          start=end+1;
	          param = param.substring(start,param.length());
	          start=0;
	        }
	        else{  // maybe last pair	        
				  if (row==0)
//				  	value = URLDecoder.decode(param,"8859_1");
					value = param;
				  else
//		          	value = URLDecoder.decode(subStr,"8859_1");
					value = subStr;

		          table.put(fieldname, value);
	            return table;
	        }
	      }
	      */
	  }
	  catch(Exception e){
//	  	e.printStackTrace();
		System.out.println("Error: " + e.getMessage());
	  }
      return table;

	}
	
}