/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.log;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;


/**
 *
 */
public class OpenFileDialog extends javax.swing.JDialog implements ListSelectionListener{
	// Variables declaration
	private final String FRAME_NAME = "Open Log File";
	private javax.swing.JPanel BottomPanel;
	private javax.swing.JButton btnCancel;
	private javax.swing.JButton btnOk;
	private javax.swing.JList fileList;
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JTextField upperText;
	private javax.swing.JTextField statusBar;
	private String logName = null;
	   
	public OpenFileDialog() {
		initComponents();
		createList();
	}

	private void createList(){
		
		File dir = new File(System.getProperty("user.dir") + File.separator + Dump.PROJECT_DIR);
    
		String[] children = dir.list();
		if (children != null) {
			Pattern logPattern = Pattern.compile("(.+)"+ "_" + Dump.INDEX_FILE);
			Matcher matcher = null;
			for (int i=0; i<children.length; i++) {
				// get filename
				String filename = children[i];
				matcher = logPattern.matcher(filename);
				if (matcher.find()){
					listModel.addElement(matcher.group(1));
				}
				
			}
		}

//		listModel.addElement("test1");
//		listModel.addElement("test2");
		setListModel(listModel);
		    
	}
    
	private void initComponents() {
		jScrollPane1 = new javax.swing.JScrollPane();
		fileList = new javax.swing.JList();
		BottomPanel = new javax.swing.JPanel();
		btnOk = new javax.swing.JButton();
		btnCancel = new javax.swing.JButton();
		upperText = new javax.swing.JTextField();
		statusBar = new javax.swing.JTextField();

		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				exitForm(evt);
			}
		});

		jScrollPane1.setViewportView(fileList);

		JPanel centerPanel = new JPanel(new java.awt.BorderLayout());
		
		btnOk.setText("Ok");
		btnOk.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				btnOkActionPerformed(evt);
			}
		});

//		BottomPanel.setLayout(new java.awt.BorderLayout());
		BottomPanel.add(btnOk);
		btnCancel.setText("Cancel");
		btnCancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				btnCancelActionPerformed(evt);
			}
		});
		BottomPanel.add(btnCancel);

//		JPanel BottomPanel2 = new JPanel();
//		BottomPanel2.add(statusBar);


		statusBar.setEditable(false);
		statusBar.setText("");
		centerPanel.add(jScrollPane1, java.awt.BorderLayout.CENTER);
		centerPanel.add(BottomPanel,java.awt.BorderLayout.SOUTH);

		getContentPane().add(centerPanel, java.awt.BorderLayout.CENTER);
		getContentPane().add(statusBar, java.awt.BorderLayout.SOUTH);

//		upperText.setBackground(java.awt.SystemColor.activeCaptionBorder);
		upperText.setEditable(false);
		upperText.setText("Select a log below in Paros directory 'Project'");
		getContentPane().add(upperText, java.awt.BorderLayout.NORTH);
		this.setResizable(false);
		this.setTitle(FRAME_NAME);
		fileList.addListSelectionListener(this);

		pack();
	}

	private void btnOkActionPerformed(java.awt.event.ActionEvent evt) {
		// don't use Global.dumpAnalyzer as that one is for current session
		DumpAnalyzerGUI dumpGUI = new DumpAnalyzerGUI(new Dump(logName,false,false));
		dumpGUI.setCurSession(false);
		String createDate = ""; 
		if (logName.indexOf("_") != -1){
			SimpleDateFormat staticDateFormat = new SimpleDateFormat();
			Date dateTime = new Date(Long.parseLong(logName.substring(logName.indexOf("_")+1,logName.length())));
			createDate = " , Created on " + staticDateFormat.format(dateTime);			
		}

		dumpGUI.setTitle(logName + createDate);
		dumpGUI.show();
/*
		if (logName!=null){
		Global.dumpLog.setDumpPrefix(logName);
		Global.dumpAnalyzer.setCurSession(false);
		Global.dumpAnalyzer.refresh();
		}
*/		
		this.dispose();
	}

	private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {
		//System.exit(0);
		this.dispose();
	}
    
	/** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt) {
		this.dispose();
	}

	public void setListModel(DefaultListModel m) {
		listModel = m;
		fileList.setModel(m);
	}

	// for selection of list
	public void valueChanged(ListSelectionEvent evt) {
		if (!evt.getValueIsAdjusting()) {
			if (fileList.getSelectedValue()==null) return;
			logName = (String) fileList.getSelectedValue();
		}
		if (logName !=null && logName.indexOf("_") != -1){
			SimpleDateFormat staticDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
			Date dateTime = new Date(Long.parseLong(logName.substring(logName.indexOf("_")+1,logName.length())));
			String createDate = "Created on " + staticDateFormat.format(dateTime);			
			statusBar.setText(createDate);
		}
		else if (logName !=null && logName.equals("session")){
			statusBar.setText("Current session log file");
		}
		else if (logName !=null && logName.equals("scan")){
			statusBar.setText("Last scan log file");
		}
		else
			statusBar.setText("");
	}
    
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		Locale.setDefault(Locale.ENGLISH);

		OpenFileDialog d = new OpenFileDialog();	
		d.show();
		   
	}
    
	private DefaultListModel listModel = new DefaultListModel();
    
	/**
	 * @return
	 */
	public DefaultListModel getListModel() {
		return listModel;
	}

}