/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;


public class ParsedURL extends ParsedEntity {


	private Hashtable		mTableQueryURL			= new Hashtable();
	private Hashtable		mTableQueryBody			= new Hashtable();
	private final static 	Pattern patternQuery	= Pattern.compile("([^/?=&]+)=([^/?=&]*)&?");

	public ParsedURL(String caption, HttpRequestHeader req, HttpBody body)
		throws HttpMalformedHeaderException, URISyntaxException {
		
		super(caption, req, body);

		analyse(req, body);
	}

	private void analyse(HttpRequestHeader req, HttpBody body) throws URISyntaxException {
		
		// also deblock query param
		parseQuery(req, body);
	}



	private void parseQuery(HttpRequestHeader req, HttpBody body) throws URISyntaxException {
		mTableQueryURL.clear();
		mTableQueryBody.clear();
		
		String query = "";
		try {
			query = (new URI(req.getURIHostPathQuery())).getQuery();
			parseQueryParam(query, mTableQueryURL, patternQuery);
		} catch (Exception e) {
		}

		try {
			query = body.toString().trim();
			parseQueryParam(query, mTableQueryBody, patternQuery);
		} catch (Exception e) {
		}
	}
	
	private void parseQueryParam(String query, Hashtable table, Pattern p) {

		Matcher matcher = p.matcher(query);		
		while (matcher.find()) {
			String field	= matcher.group(0);
			String val		= matcher.group(1);
			if (field != null && val != null && !field.equals("")) {
				table.put(field, val);
			}
		}
		
	}

}
