/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros;

import com.proofsecure.paros.AdminServer;
import com.proofsecure.paros.Global;
import com.proofsecure.paros.ProxyHandler;
import com.proofsecure.paros.Session;
import com.proofsecure.paros.document.WebLink;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpInputStream;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpOutputStream;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.scan.ParsedEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AdminHandler
extends ProxyHandler {
    private static AdminServer server = null;
    private String sessionID = null;
    private boolean isNewSession = false;

    AdminHandler() {
    }

    AdminHandler(AdminServer s) {
        server = s;
    }

    public void start(Socket sock) {
        this.mInSocket = sock;
        super.start(sock, true);
    }

    protected void disconnect() {
        try {
            this.mClientHttpOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void assumeProxy() {
        this.mClientHttpInReqHeader.setAbsoluteUriRequired(false);
    }

    protected void afterRequestHeaderRead(HttpRequestHeader req) {
        req.setSecure(true);
    }

    private void sendError() throws Exception {
        this.sendResponse(String.valueOf(server.getDocRoot()) + File.separator + "error.htm");
    }

    private void sendError(String idata) throws Exception {
        String crlf = "\r\n";
        String data = "<html><body link=#0000FF alink=#0000FF vlink=#0000FF>" + crlf;
        data = String.valueOf(data) + idata + "<br>" + crlf;
        data = String.valueOf(data) + "</body></html>" + crlf;
        this.sendDataResponse(data);
    }

    private void mnuCache(Hashtable param) throws Exception {
        String command = (String)param.get("Submit");
        if (command != null && command.equalsIgnoreCase("Clear Cache")) {
            Global.webDoc.clear();
        }
        this.sendResponse(String.valueOf(server.getDocRoot()) + File.separator + "cache" + File.separator + "lower.htm");
    }

    private void mnuCacheFunction(Hashtable param) throws Exception {
        String crlf = "\r\n";
        String command = (String)param.get("Submit");
        if (command != null && command.equalsIgnoreCase("Toggle Mode")) {
            Global.isOffline = !Global.isOffline;
            String mode = Global.isOffline ? "Offline Mode" : "Online Mode";
            Global.parosFrame.logAppend("===================== Switched to " + mode + " =====================" + crlf);
        }
        String data = "<html><body>" + crlf;
        String mode = Global.isOffline ? "On" : "Off";
        data = String.valueOf(data) + "Offline Mode: " + mode + crlf;
        data = String.valueOf(data) + "<form name=form1 method=post action=''>" + crlf;
        data = String.valueOf(data) + "<input type=submit name=Submit value='Toggle Mode'></form>" + crlf;
        data = String.valueOf(data) + "<form name=form2 action=javascript:window.location.replace('/cache') target=_parent>" + crlf;
        data = String.valueOf(data) + "<input type=submit name=Submit value='Refresh Cache'></form>" + crlf;
        data = String.valueOf(data) + "<form name=form2 method=post action='/cache' target=_parent>" + crlf;
        data = String.valueOf(data) + "<input type=submit name=Submit value='Clear Cache'></form>" + crlf;
        data = String.valueOf(data) + "</body></html>" + crlf;
        this.sendDataResponse(data);
    }

    private void mnuCacheContent() throws Exception {
        String crlf = "\r\n";
        String data = "<html><body link=#0000FF alink=#0000FF vlink=#0000FF>" + crlf;
        data = String.valueOf(data) + "Total no. of cached URLs = " + Global.webDoc.getHistorySize() + " <br>";
        data = String.valueOf(data) + "<font size=2>";
        data = String.valueOf(data) + "<br>Cached pages with 'html' tag embedded in the body are shown in blue color, ";
        data = String.valueOf(data) + "other pages are shown in light grey color. ";
        data = String.valueOf(data) + "Note that you may not be able to see those pages with 3xx status codes as they are cached in web browser, but not in Paros.<br>" + crlf;
        data = String.valueOf(data) + "<br>In order to view the cache, please switch/toggle to Offline mode first. Otherwise, clicking the following links will retrieve pages from website directly.<br>" + crlf;
        data = String.valueOf(data) + "<br>[status code]  website_URL<br>" + crlf;
        data = String.valueOf(data) + "</font>";
        data = String.valueOf(data) + Global.webDoc.toHTML();
        data = String.valueOf(data) + "</body></html>" + crlf;
        this.sendDataResponse(data);
    }

    private void sendResponse(String path) throws Exception {
        int len;
        boolean exists;
        File dfile = new File(path);
        int CLen = (int)dfile.length();
        byte[] buffer = new byte[4096];
        boolean bl = exists = dfile.exists() && dfile.length() != 0L;
        if (!exists) {
            String lastsite = server.getSession().getLastSite(this.sessionID);
            if (lastsite != null) {
                String newpath = null;
                String sitename = null;
                String sitepath = null;
                int i = path.indexOf(server.getDocRoot());
                if (i != -1) {
                    newpath = path.substring(server.getDocRoot().length() + 1);
                }
                if ((i = newpath.indexOf("/")) != -1) {
                    sitename = newpath.substring(0, i);
                    sitepath = newpath.substring(i);
                }
                System.out.println("site " + sitename);
                System.out.println("sitepath " + sitepath);
                if (sitename != null && sitepath != null) {
                    WebLink doc;
                    ParsedEntity entity = Global.treePanel.getRoot();
                    boolean siteflag = false;
                    int d = 0;
                    while (d < entity.getChildCount()) {
                        try {
                            if (((ParsedEntity)entity.getChildAt(d)).getHostName().equalsIgnoreCase(sitename)) {
                                siteflag = true;
                                break;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++d;
                    }
                    if (!siteflag) {
                        sitename = lastsite;
                        sitepath = "/" + newpath;
                    }
                    if ((doc = (WebLink)Global.webDoc.getHistory(sitename, sitepath)) != null && this.mClientHttpOut != null) {
                        if (doc.getRespHeader() != null) {
                            this.mClientHttpOut.write(doc.getRespHeader());
                        }
                        if (doc.getRespContent() != null) {
                            this.mClientHttpOut.write(doc.getRespContent());
                        } else {
                            this.mClientHttpOut.flush();
                        }
                        if (server != null && this.sessionID != null) {
                            server.getSession().updateSession(this.sessionID, sitename);
                        }
                        return;
                    }
                }
                dfile = new File(String.valueOf(server.getDocRoot()) + File.separator + "error.htm");
                CLen = (int)dfile.length();
            } else {
                dfile = new File(String.valueOf(server.getDocRoot()) + File.separator + "error.htm");
                CLen = (int)dfile.length();
            }
        }
        FileInputStream fileIn = new FileInputStream(dfile);
        HttpResponseHeader header = this.createResponseHeader(CLen);
        this.mClientHttpOut.write(header);
        while ((len = fileIn.read(buffer)) > 0) {
            this.mClientHttpOut.write(buffer, len);
        }
        this.mClientHttpOut.flush();
        fileIn.close();
        if (server != null && this.sessionID != null) {
            server.getSession().updateSession(this.sessionID, null);
        }
    }

    public void sendRedirectResponse(String url) throws Exception {
        String data = "<HTML><BODY><SCRIPT>window.location.replace('" + url + "')</SCRIPT></BODY>/HTML>";
        Object lastSite = null;
        HttpResponseHeader header = this.createResponseHeader(data.length());
        this.mClientHttpOut.write(header);
        this.mClientHttpOut.write(new HttpBody(data));
        this.mClientHttpOut.flush();
        if (server != null && this.sessionID != null) {
            server.getSession().updateSession(this.sessionID, null);
        }
    }

    public void sendDataResponse(String data) throws Exception {
        Object lastSite = null;
        HttpResponseHeader header = this.createResponseHeader(data.length());
        this.mClientHttpOut.write(header);
        this.mClientHttpOut.write(new HttpBody(data));
        this.mClientHttpOut.flush();
        if (server != null && this.sessionID != null) {
            server.getSession().updateSession(this.sessionID, null);
        }
    }

    public HttpResponseHeader createResponseHeader(int bodyLen) {
        String crlf = "\r\n";
        SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
        String data = "HTTP/1.0 200 OK" + crlf;
        data = String.valueOf(data) + "Date: " + formatter.format((Object)new Date()) + " GMT" + crlf;
        data = String.valueOf(data) + "Server: paros" + crlf;
        if (this.isNewSession && this.sessionID != null) {
            data = String.valueOf(data) + "Set-cookie: " + this.sessionID + crlf;
            this.isNewSession = false;
        }
        data = String.valueOf(data) + "Content-Length: " + bodyLen + crlf;
        data = String.valueOf(data) + "Content-Type: text/html" + crlf;
        data = String.valueOf(data) + "Connection: Close" + crlf + crlf;
        HttpResponseHeader header = null;
        try {
            header = new HttpResponseHeader(data);
            header.setHeader("Cache-Control", "no-cache");
            header.setHeader("Pragma", "no-cache");
            header.setHeader("Expires", "0");
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            // empty catch block
        }
        return header;
    }

    private boolean validate(HttpRequestHeader header, HttpBody body) {
        String path = header.getURIPathQuery();
        if (path == null || path.equals("")) {
            return false;
        }
        if (this.sessionID != null && !this.sessionID.equals("") && !this.sessionID.matches("(\\d+)")) {
            return false;
        }
        try {
            String realpath = String.valueOf(AdminServer.DOCROOT) + path;
            File dfile = new File(realpath);
            String canonicalPath = dfile.getCanonicalPath();
            if (!canonicalPath.equalsIgnoreCase(dfile.getAbsolutePath())) {
                System.out.println("Path not canonical");
                return false;
            }
            if (!canonicalPath.toUpperCase().startsWith(AdminServer.DOCROOT.toUpperCase())) {
                System.out.println("Path not under root directory");
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void perform(String command, Hashtable param) {
    }

    private void parse(HttpRequestHeader header, HttpBody body) throws Exception {
        String path = header.getURIPathQuery();
        Pattern pattern = Pattern.compile("/(\\d+)");
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            this.isNewSession = false;
            Vector result = Global.dumpAnalyzer.searchResponse(String.valueOf(matcher.group(1)) + "." + Global.dumpLog.getCurDate());
            if (result != null) {
                String data = (String)result.get(1);
                HttpResponseHeader header2 = new HttpResponseHeader((String)result.get(0));
                if (header2.getStatusCode() == 301 || header2.getStatusCode() == 302) {
                    header2 = this.createResponseHeader(data.length());
                }
                this.mClientHttpOut.write(header2);
                this.mClientHttpOut.write(new HttpBody(data));
                this.mClientHttpOut.flush();
                if (server != null && this.sessionID != null) {
                    server.getSession().updateSession(this.sessionID, null);
                }
                return;
            }
        }
        this.sendError("No body content for this recorded response (" + path + ")");
    }

    private void parse2(HttpRequestHeader header, HttpBody body) throws Exception {
        String path = header.getURIPathQuery();
        String realpath = String.valueOf(AdminServer.DOCROOT) + path;
        if (header.isImage()) {
            this.isNewSession = false;
            this.sendResponse(realpath);
            return;
        }
        if (header != null && header.getMethod().equals("POST") && path.equals("/logon")) {
            if (this.logon(body)) {
                this.sendRedirectResponse("/menu.htm");
            } else {
                this.sendRedirectResponse("/login.htm");
            }
            return;
        }
        if (path.equals("/logout")) {
            int status = server.getSession().getStatus(this.sessionID);
            if (status == Session.NOT_EXISTED) {
                this.sendError();
                return;
            }
            if (status == Session.EXPIRED) {
                this.sessionID = "";
                this.isNewSession = true;
                this.sendResponse(String.valueOf(AdminServer.DOCROOT) + File.separator + "expired.htm");
                return;
            }
            this.logout();
            this.sessionID = "";
            this.isNewSession = true;
            this.sendResponse(String.valueOf(AdminServer.DOCROOT) + File.separator + "logout.htm");
            return;
        }
        if (path.equals("/view")) {
            int status = server.getSession().getStatus(this.sessionID);
            if (status == Session.NOT_EXISTED) {
                this.sendError();
                return;
            }
            if (status == Session.EXPIRED) {
                this.sessionID = "";
                this.isNewSession = true;
                this.sendResponse(String.valueOf(AdminServer.DOCROOT) + File.separator + "expired.htm");
                return;
            }
            Hashtable param = this.parseParameter(body.toString());
            String pageindex = (String)param.get("pageindex");
            if (pageindex != null) {
                int index;
                try {
                    index = Integer.parseInt(pageindex);
                }
                catch (NumberFormatException fe) {
                    index = -1;
                }
                WebLink doc = (WebLink)Global.webDoc.getHistory(index);
                if (this.mClientHttpOut == null) {
                    this.mClientHttpOut = new HttpOutputStream(this.mInSocket.getOutputStream());
                }
                if (doc != null && this.mClientHttpOut != null) {
                    HttpRequestHeader reqheader = (HttpRequestHeader)doc.getReqHeader();
                    String query = reqheader.getURIHostPathQuery();
                    int i = query.indexOf("http://");
                    if (i != -1) {
                        query = query.substring(i + 7);
                    }
                    if ((i = query.indexOf("https://")) != -1) {
                        query = query.substring(i + 8);
                    }
                    this.sendRedirectResponse(query);
                } else {
                    this.sendError();
                    return;
                }
            }
            return;
        }
        if (path.equals("/") || path.equals("/login.htm")) {
            if (this.sessionID != null) {
                server.getSession().removeSession(this.sessionID);
                this.sessionID = "";
                this.isNewSession = true;
            }
            String filename = String.valueOf(AdminServer.DOCROOT) + File.separator + "login.htm";
            this.sendResponse(filename);
            return;
        }
        int status = server.getSession().getStatus(this.sessionID);
        if (status == Session.NOT_EXISTED) {
            this.sendError();
            return;
        }
        if (status == Session.EXPIRED) {
            this.sessionID = "";
            this.isNewSession = true;
            this.sendResponse(String.valueOf(AdminServer.DOCROOT) + File.separator + "expired.htm");
            return;
        }
        if (path.equals("/cache")) {
            Hashtable param = this.parseParameter(body.toString());
            this.mnuCache(param);
            return;
        }
        if (path.equals("/cache/status")) {
            Hashtable param = this.parseParameter(body.toString());
            this.mnuCacheFunction(param);
            return;
        }
        if (path.equals("/cache/content")) {
            this.mnuCacheContent();
            return;
        }
        this.sendResponse(realpath);
    }

    public void run() {
        try {
            this.mClientHttpIn = new HttpInputStream(this.mInSocket.getInputStream());
            this.mClientHttpOut = new HttpOutputStream(this.mInSocket.getOutputStream());
            this.mClientHttpInReqHeader = (HttpRequestHeader)this.mClientHttpIn.readHeader();
            this.mClientHttpInReqBody = this.mClientHttpIn.readBody();
            this.mHostName = this.mClientHttpInReqHeader.getHostName();
            this.mHostPort = this.mClientHttpInReqHeader.getHostPort();
            this.sessionID = this.mClientHttpInReqHeader.getHeader("Cookie");
            if (this.mClientHttpInReqHeader.getHeader(server.getAuthCode()) == null) {
                this.sendError();
                this.disconnect();
                return;
            }
            this.parse(this.mClientHttpInReqHeader, this.mClientHttpInReqBody);
        }
        catch (HttpMalformedHeaderException e) {
            try {
                HttpResponseHeader errResponse = HttpResponseHeader.getError("HTTP/1.0 400 Bad request\r\n\r\n");
                this.mClientHttpOut.write(errResponse);
                this.mClientHttpOut.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.showErrMessage("Malformed HTTP header from client.");
        }
        catch (IOException ioe) {
            this.showErrMessage("Error: " + ioe.getMessage() + ". connection closed");
        }
        catch (Exception e) {
            this.showErrMessage("Error: " + e.getMessage());
            e.printStackTrace();
        }
        this.disconnect();
    }

    private boolean logon(HttpBody body) {
        String pwd;
        boolean valid = false;
        Hashtable param = this.parseParameter(body.toString());
        String name = (String)param.get("textfield1");
        if (name != null && (pwd = (String)param.get("textfield12")) != null && name.equals("admin") && pwd.equals("testing")) {
            valid = true;
        }
        if (valid && server != null) {
            this.sessionID = server.getSession().createSession();
            this.isNewSession = true;
            return true;
        }
        return false;
    }

    private boolean logout() {
        if (server != null && this.sessionID != null && server.getSession().getStatus(this.sessionID) == Session.EXISTED) {
            server.getSession().removeSession(this.sessionID);
            return true;
        }
        return false;
    }

    private Hashtable parseParameter(String param) {
        int end = 0;
        int start = 0;
        int row = 0;
        int col = 0;
        String fieldname = null;
        String value = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            while (row < 80 && (end = param.indexOf(61)) != -1) {
                String subStr = param.substring(start, end);
                fieldname = URLDecoder.decode(subStr, "8859_1");
                ++col;
                start = end + 1;
                param = param.substring(start, param.length());
                start = 0;
                end = param.indexOf(38);
                if (end != -1) {
                    subStr = param.substring(start, end);
                    value = URLDecoder.decode(subStr, "8859_1");
                    table.put(fieldname, value);
                    ++row;
                    col = 0;
                    start = end + 1;
                    param = param.substring(start, param.length());
                    start = 0;
                    continue;
                }
                value = row == 0 ? URLDecoder.decode(param, "8859_1") : URLDecoder.decode(subStr, "8859_1");
                table.put(fieldname, value);
                return table;
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
        return table;
    }
}

