/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros;

import com.proofsecure.paros.AdminServer;
import com.proofsecure.paros.FilterManager;
import com.proofsecure.paros.Global;
import com.proofsecure.paros.Proxy;
import com.proofsecure.paros.SSLProxy;
import com.proofsecure.paros.document.WebDoc;
import com.proofsecure.paros.network.SSLConnector;
import com.proofsecure.paros.scan.ScanManager;
import com.proofsecure.paros.scan.Scanner;
import com.proofsecure.paros.ui.LicenseFrame;
import com.proofsecure.paros.ui.ParosFrame;
import com.proofsecure.paros.ui.TrapPanel;
import com.proofsecure.paros.ui.TreePanel;
import com.proofsecure.paros.util.Config;
import com.proofsecure.paros.util.Util;
import com.sun.net.ssl.internal.ssl.Provider;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.Security;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Paros {
    private static final String PARAM_TUNNEL = "-tunnel";
    private static final String PARAM_SSL_IN = "-sslin";
    private static final String PARAM_SSL_OUT = "-sslout";
    private static final String PARAM_NOUSERAGENT1 = "-noUserAgent";
    private static final String PARAM_NOUSERAGENT2 = "-u";
    private static final String PARAM_HELP1 = "-help";
    private static final String PARAM_HELP2 = "-h";
    private static final String PARAM_SOURCE = "-source";
    private boolean packFrame = false;
    private ParosFrame frame = null;

    public Paros(ParosFrame frame) {
        this.frame = frame;
        if (this.packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    private ParosFrame getFrame() {
        return this.frame;
    }

    private static void showLicense() {
        if (!new File("AcceptedLicense").exists()) {
            LicenseFrame license = new LicenseFrame();
            license.showFrame();
            while (!license.isAcceptLicense()) {
                Util.sleep(100);
            }
            try {
                FileWriter fo = new FileWriter("AcceptedLicense");
                fo.close();
            }
            catch (IOException ie) {
                JOptionPane.showMessageDialog(new JFrame(), "Unknown Error. Please report to the author.");
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            try {
                if (!Paros.parseOptions(args)) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                Paros.writeConsole("Invalid parameters.");
                Paros.displayHelp();
                System.exit(1);
            }
        }
        Locale.setDefault(Locale.ENGLISH);
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        Security.addProvider((java.security.Provider)new Provider());
        if (Global.isRunGUI) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Paros.initGlobalData();
            Paros.initCommandLine();
            while (true) {
                Util.sleep(10000);
            }
        }
        Global.splash.start();
        Paros.initGlobalData();
        Paros.initUI();
    }

    private static void initGlobalData() throws Exception {
        Global.ssl = new SSLConnector();
        Global.filterManager = new FilterManager();
        Global.scanManager = new ScanManager();
        Global.config = new Config();
        Global.proxy = null;
        Global.SSLProxy = null;
        Global.adminServer = null;
        Global.parosFrame = null;
        Global.treePanel = new TreePanel();
        Global.trapPanel = new TrapPanel();
        Global.scanner = new Scanner();
        Global.webDoc = new WebDoc();
        Global.findDialog = null;
        Global.ssl.init();
    }

    private static void initCommandLine() {
        boolean success = true;
        try {
            Global.config.read("options.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!success) {
            return;
        }
        if (Global.isCmdSSLin) {
            Global.SSLProxy = new SSLProxy("localhost", Global.cmdSourcePort);
            success = true;
            success = Global.SSLProxy.startServer();
            if (!success) {
                Paros.writeConsole("Error tunnel initialization, please exit.");
                System.exit(1);
            }
        } else {
            Global.proxy = new Proxy("localhost", Global.cmdSourcePort);
            success = true;
            success = Global.proxy.startServer();
            if (!success) {
                Paros.writeConsole("Error tunnel initialization, please exit.");
                System.exit(1);
            }
        }
        Paros.writeConsole("Tunneling = " + Global.cmdHostName + ":" + Global.cmdHostPort);
        Paros.writeConsole("Source port = " + Global.cmdSourcePort);
    }

    private static void initUI() {
        Paros.showLicense();
        Global.parosFrame = new ParosFrame();
        Paros proxyH = new Paros(Global.parosFrame);
        ParosFrame mframe = proxyH.getFrame();
        boolean success = false;
        success = true;
        if (success) {
            Global.proxy = new Proxy(Global.config.getProxyIP(), Global.config.getProxyPort());
            success = true;
            success = Global.proxy.startServer();
            if (!success) {
                mframe.setStatus("Error proxy server initialization, please exit.");
            }
        }
        if (success) {
            mframe.setStatus("Please wait...");
            Global.SSLProxy = new SSLProxy(Global.config.getProxyIP(), Global.config.getProxyPortSSL());
            success = Global.SSLProxy.startServer();
            if (!success) {
                mframe.setStatus("Error SSL proxy server initialization, please exit");
            }
        }
        if (success && Global.isRunAdminServer && !(success = (Global.adminServer = new AdminServer(AdminServer.ADMIN_SERVER_NAME, AdminServer.ADMIN_SERVER_PORT)).startServer())) {
            mframe.setStatus("Error Admin server initialization, please exit");
        }
        if (success) {
            mframe.setStatus("Ready");
        }
        Global.splash.cleanup();
    }

    private static void displayHelp() {
        String CRLF = "\r\n";
        String help = "Usage:\tjava -jar paros.jar [-tunnel dest_host:port [-sslin] [-sslout]] [-source this_host:port] [-help]" + CRLF + CRLF + "\t" + PARAM_TUNNEL + ":\t" + "destination host and port to tunnel, use proxy in configuration." + CRLF + "\t" + PARAM_SSL_IN + ":\t\t" + "enable ssl tunnelling input." + CRLF + "\t" + PARAM_SSL_OUT + ":\t" + "enable ssl tunnelling output." + CRLF + "\t" + PARAM_SOURCE + ":\t" + "local source server and port for tunnel." + CRLF + "\t" + PARAM_HELP1 + "|" + PARAM_HELP2 + ":\t" + "display this help screen." + CRLF + "Example: java -jar paros.jar -tunnel www.any_host.com:443 -sslout -source localhost:80" + CRLF + "then try telnet to localhost:80" + CRLF;
        Paros.writeConsole(help);
    }

    private static boolean parseOptions(String[] args) throws Exception {
        int pos = 0;
        String sHost = null;
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                if (args[i].equalsIgnoreCase(PARAM_NOUSERAGENT1) || args[i].equalsIgnoreCase(PARAM_NOUSERAGENT2)) {
                    Global.isModifyUserAgent = false;
                    args[i] = null;
                } else if (args[i].equalsIgnoreCase(PARAM_TUNNEL)) {
                    Global.isCmdTunnel = true;
                    args[i] = null;
                    Global.isRunGUI = false;
                    pos = 0;
                    sHost = args[i + 1];
                    pos = sHost.indexOf(58, 2);
                    if (pos <= -1) {
                        return false;
                    }
                    Global.cmdHostName = sHost.substring(0, pos).trim();
                    Global.cmdHostPort = Integer.parseInt(sHost.substring(pos + 1));
                    args[i + 1] = null;
                } else if (args[i].equalsIgnoreCase(PARAM_SSL_OUT)) {
                    Global.isCmdSSLout = true;
                    args[i] = null;
                } else if (args[i].equalsIgnoreCase(PARAM_SSL_IN)) {
                    Global.isCmdSSLin = true;
                    args[i] = null;
                } else if (args[i].equalsIgnoreCase(PARAM_SOURCE)) {
                    args[i] = null;
                    pos = 0;
                    sHost = args[i + 1];
                    pos = sHost.indexOf(58, 2);
                    if (pos <= -1) {
                        return false;
                    }
                    Global.cmdSourceHost = sHost.substring(0, pos).trim();
                    Global.cmdSourcePort = Integer.parseInt(sHost.substring(pos + 1));
                    args[i + 1] = null;
                } else if (args[i].equalsIgnoreCase(PARAM_HELP1) || args[i].equalsIgnoreCase(PARAM_HELP2)) {
                    Global.isRunGUI = false;
                    Paros.displayHelp();
                    System.exit(0);
                } else if (args[i].equalsIgnoreCase("-st")) {
                    args[i] = null;
                    Global.isST = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void writeConsole(String s) {
        System.out.println(s);
    }
}

