/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.filter;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.filter.AbstractFilter;
import com.proofsecure.paros.filter.PDialog;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.scan.TestCacheAndMisc;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class DetectUnsafeContent
extends AbstractFilter {
    private JDialog dialog = new PDialog("DetectUnsafeContent");
    private static final int DEFAULT = 10;
    private static final Pattern[] patternBadHeaderList = new Pattern[]{Pattern.compile("Content-type:\\s+application/hta", 10), Pattern.compile("Content-Disposition: attachment; filename=[^{}]+\\{[\\w\\d\\-]*\\}[^{}]+", 10)};
    private static final String[] patternBadHeaderDesc = new String[]{"Suspicious content-type header 'application/hta'", "MS IE Microsoft Internet Explorer CLSID File Extension Misrepresentation Vulnerability (http://www.securityfocus.com/bid/9510)"};
    private static final Pattern[] patternBadBodyList = new Pattern[]{Pattern.compile("^.*file:javascript:eval.*$", 10), Pattern.compile("<[^>]*CLSID:11111111-1111-1111-1111-11111111111[^>]*>", 10), Pattern.compile("^.*Scripting\\.FileSystemObject.*$", 10), Pattern.compile("^.*new\\s+ActiveXObject.*$", 10), Pattern.compile("<OBJECT\\s+[^>]+>", 10), Pattern.compile("https?://[^\\s\"']+?@[^\\s\"']+?", 10), Pattern.compile("^.*Microsoft\\.XMLHTTP.*$", 10), Pattern.compile("^.*SaveToFile.*$", 10), Pattern.compile("^.*CreateObject(\\s*[\"']+Adodb.Stream[\"']\\s*)$", 10), Pattern.compile("^.*execcommand.*$", 10), Pattern.compile("ms-its:mhtml:file://", 10), Pattern.compile("<iframe[^>]+src=['\"]*shell:[^>]+>", 10)};
    private static final String[] patternBadBodyDesc = new String[]{"Suspcious use of javascript 'file:javascript:eval'.", "Suspicious ActiveX CLSID 11111111-1111-1111-1111-... being used.", "Attempt to access Scripting.FileSystemObject.", "Inline creation of ActiveX object.", "ActiveX object used.", "URL with '@' to obscure hyperlink.", "Suspicious use of ActiveX XMLHTTP object (http://www.securityfocus.com/bid/8577)", "Suspicious scripting attempt to access local file via SafeToFile.  MS IE Self Executing HTML Arbitrary Code Execution Vulnerability.  (http://www.securityfocus.com/bid/8984)", "MS IE Self Executing HTML Arbitrary Code Execution Vulnerability.  (http://www.securityfocus.com/bid/8984)", "MS IE ExecCommand Cross-Domain Access Violation Vulnerability (http://www.securityfocus.com/bid/9015)", "MS IE MT-ITS Protocol Zone Bypass Vulnerability (http://www.securityfocus.com/bid/9658)", "MS IE Shell: IFrame Cross-Zone Scripting Vulnerability (http://www.securityfocus.com/bid/9628)"};

    public JDialog getDialog() {
        return this.dialog;
    }

    public void filterRequest(HttpRequestHeader reqHeader, HttpBody reqBody) {
    }

    public void filterResponse(HttpRequestHeader reqHeader, HttpResponseHeader resHeader, HttpBody resBody) {
        if (resHeader.isImage()) {
            return;
        }
        try {
            this.checkAutocomplete(reqHeader, resHeader, resBody);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.checkMaliciousCode(reqHeader, resHeader, resBody);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String usage() {
        return "Detect insecure or potentially unsafe response (see output)";
    }

    private void writeOutput(String hostPath, String msg, String match) {
        Global.parosFrame.logAppend("Output", "+ " + hostPath + "\r\n");
        Global.parosFrame.logAppend("Output", "- " + msg + "\r\n");
        if (match != null) {
            Global.parosFrame.logAppend("Output", "- " + match + "\r\n");
        }
        Global.parosFrame.logAppend("Output", "\r\n");
    }

    private void checkAutocomplete(HttpRequestHeader reqHeader, HttpResponseHeader resHeader, HttpBody body) {
        String txtBody = body.toString();
        String txtForm = null;
        String txtInput = null;
        Matcher matcherForm = TestCacheAndMisc.patternForm.matcher(txtBody);
        Matcher matcherAutocomplete = null;
        while (matcherForm.find()) {
            txtForm = matcherForm.group(1);
            txtInput = matcherForm.group(2);
            if (txtForm == null || txtInput == null || (matcherAutocomplete = TestCacheAndMisc.patternAutocomplete.matcher(txtForm)).find() || (matcherAutocomplete = TestCacheAndMisc.patternAutocomplete.matcher(txtInput)).find()) continue;
            this.writeOutput(reqHeader.getURIHostPath(), "Password field without setting autocomplete to off found.", txtInput);
        }
    }

    private void checkMaliciousCode(HttpRequestHeader reqHeader, HttpResponseHeader resHeader, HttpBody body) {
        Pattern bad = null;
        Matcher matcher = null;
        String txtHeader = reqHeader.toString();
        String txtBody = body.toString();
        int i = 0;
        while (i < patternBadHeaderList.length) {
            bad = patternBadHeaderList[i];
            matcher = bad.matcher(txtHeader);
            while (matcher.find()) {
                this.writeOutput(reqHeader.getURIHostPath(), patternBadHeaderDesc[i], matcher.group(0));
            }
            ++i;
        }
        i = 0;
        while (i < patternBadBodyList.length) {
            bad = patternBadBodyList[i];
            matcher = bad.matcher(txtBody);
            while (matcher.find()) {
                this.writeOutput(reqHeader.getURIHostPath(), patternBadBodyDesc[i], matcher.group(0));
            }
            ++i;
        }
    }

    private boolean checkAllow(String code) {
        Global.parosFrame.toFront();
        String text = JOptionPane.showInputDialog(Global.parosFrame, "Suspicious code found.  Accept it? (OK=Accept, Cancel=filter it)", code);
        return text == null || text.equals("");
    }
}

