/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.network;

import com.proofsecure.paros.network.HttpInputStream;
import com.proofsecure.paros.network.HttpOutputStream;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.network.RelaxedX509TrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLConnector {
    private static final String CRLF = "\r\n";
    private SSLSocketFactory clientSSLSockFactory = null;
    private SSLSocketFactory clientSSLSockCertFactory = null;
    private ServerSocketFactory serverSSLSockFactory = null;

    public void init() {
        this.clientSSLSockFactory = this.getClientSocketFactory("SSL");
        this.serverSSLSockFactory = this.getServerSocketFactory("SSL");
    }

    public SSLSocket client(String hostName, int hostPort, boolean useClientCert) throws IOException {
        SSLSocket socket = null;
        socket = this.clientNoHandshake(hostName, hostPort, useClientCert);
        socket.startHandshake();
        return socket;
    }

    public SSLSocket clientNoHandshake(String hostName, int hostPort, boolean useClientCert) throws IOException {
        SSLSocket socket = null;
        socket = useClientCert ? (SSLSocket)this.clientSSLSockCertFactory.createSocket(hostName, hostPort) : (SSLSocket)this.clientSSLSockFactory.createSocket(hostName, hostPort);
        return socket;
    }

    public SSLSocket clientViaProxy(String hostName, int hostPort, String proxyName, int proxyPort, boolean useClientCert) throws IOException {
        SSLSocket socket = this.clientViaProxyNoHandshake(hostName, hostPort, proxyName, proxyPort, useClientCert);
        socket.startHandshake();
        return socket;
    }

    public SSLSocket clientViaProxyNoHandshake(String hostName, int hostPort, String proxyName, int proxyPort, boolean useClientCert) throws IOException {
        HttpResponseHeader res = new HttpResponseHeader();
        Socket tunnel = this.establishTunnel(hostName, hostPort, proxyName, proxyPort, res);
        if (tunnel == null) {
            return null;
        }
        SSLSocket socket = null;
        socket = useClientCert ? (SSLSocket)this.clientSSLSockCertFactory.createSocket(tunnel, hostName, hostPort, true) : (SSLSocket)this.clientSSLSockFactory.createSocket(tunnel, hostName, hostPort, true);
        return socket;
    }

    public void setClientCert(File keyFile, char[] passPhrase) throws Exception {
        this.clientSSLSockCertFactory = null;
        KeyManager[] keyMgr = null;
        TrustManager[] trustMgr = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext ctx = SSLContext.getInstance("SSL");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        KeyStore ks = KeyStore.getInstance("pkcs12");
        ks.load(new FileInputStream(keyFile), passPhrase);
        SecureRandom x = new SecureRandom();
        x.setSeed(System.currentTimeMillis());
        kmf.init(ks, passPhrase);
        ctx.init(kmf.getKeyManagers(), trustMgr, x);
        this.clientSSLSockCertFactory = ctx.getSocketFactory();
    }

    public Socket establishTunnel(String hostName, int hostPort, String proxyName, int proxyPort, HttpResponseHeader res) throws IOException {
        Socket tunnel = new Socket(proxyName, proxyPort);
        HttpInputStream tunnel_in = new HttpInputStream(tunnel.getInputStream());
        HttpOutputStream tunnel_out = new HttpOutputStream(tunnel.getOutputStream());
        HttpRequestHeader req = new HttpRequestHeader(SSLConnector.getConnectString(hostName, hostPort));
        tunnel_out.write(req);
        tunnel_out.flush();
        HttpResponseHeader tunnelRes = (HttpResponseHeader)tunnel_in.readHeader();
        res.setMessage(tunnelRes.toString());
        if (res.isMalformedHeader() || res.getStatusCode() != 200) {
            return null;
        }
        return tunnel;
    }

    public ServerSocket listen(int portNum) throws IOException {
        ServerSocket sslServerPort = null;
        sslServerPort = this.serverSSLSockFactory.createServerSocket(portNum);
        return sslServerPort;
    }

    public ServerSocket listen() throws IOException {
        ServerSocket sslServerPort = null;
        sslServerPort = this.serverSSLSockFactory.createServerSocket();
        return sslServerPort;
    }

    public ServerSocket listen(int portNum, int maxConnection) throws IOException {
        ServerSocket sslServerPort = null;
        sslServerPort = this.serverSSLSockFactory.createServerSocket(portNum, maxConnection);
        return sslServerPort;
    }

    public ServerSocket listen(int paramPortNum, int maxConnection, InetAddress ip) throws IOException {
        ServerSocket sslServerPort = this.serverSSLSockFactory.createServerSocket(paramPortNum, maxConnection, ip);
        return sslServerPort;
    }

    public SSLSocketFactory getClientSocketFactory(String type) {
        KeyManager[] keyMgr = null;
        TrustManager[] trustMgr = new TrustManager[]{new RelaxedX509TrustManager()};
        try {
            SSLContext sslContext = SSLContext.getInstance(type);
            SecureRandom x = new SecureRandom();
            x.setSeed(System.currentTimeMillis());
            sslContext.init(null, trustMgr, x);
            this.clientSSLSockFactory = sslContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(this.clientSSLSockFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.clientSSLSockFactory;
    }

    public ServerSocketFactory getServerSocketFactory(String type) {
        if (type.equals("SSL") || type.equals("SSLv3")) {
            SSLServerSocketFactory ssf = null;
            try {
                char[] passphrase = "!@#$%^&*()".toCharArray();
                SSLContext ctx = SSLContext.getInstance(type);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance("JKS");
                SecureRandom x = new SecureRandom();
                x.setSeed(System.currentTimeMillis());
                ks.load(new FileInputStream("paroskey"), passphrase);
                kmf.init(ks, passphrase);
                ctx.init(kmf.getKeyManagers(), null, x);
                ssf = ctx.getServerSocketFactory();
                return ssf;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return ServerSocketFactory.getDefault();
        }
        return null;
    }

    private static String getConnectString(String hostName, int hostPort) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("CONNECT " + hostName + ":" + hostPort + " HTTP/1.0" + CRLF);
        sb.append("User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0;)\r\n");
        sb.append("Host: " + hostName + ":" + hostPort + CRLF);
        sb.append("Pragma: no-cache\r\n");
        sb.append("Content-Length: 0\r\n");
        sb.append(CRLF);
        return sb.toString();
    }
}

