/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.scan.Report;

public class AlertItem
implements Comparable {
    public static final int RISK_INFO = 0;
    public static final int RISK_LOW = 1;
    public static final int RISK_MEDIUM = 2;
    public static final int RISK_HIGH = 3;
    public static final int NONE = 0;
    public static final int SUSPICIOUS = 1;
    public static final int WARNING = 2;
    public static final String[] MSG_RISK = new String[]{"Informational", "Low", "Medium", "High"};
    public static final String[] MSG_RELIABILITY = new String[]{"None", "Suspicious", "Warning"};
    public int risk = 0;
    public int reliability = 2;
    public int id = 0;
    public String alert = "";
    public String uri = "";
    public String desc = "";
    public String param = "";
    public String otherInfo = "";
    public String solution = "";
    public String reference = "";

    public AlertItem(int paramID) {
        this.id = paramID;
    }

    public AlertItem(int paramID, int paramRisk, int paramReliability, String paramAlert) {
        this(paramID);
        this.setRiskReliability(paramRisk, paramReliability);
        this.setAlert(paramAlert);
    }

    public void setRiskReliability(int paramRisk, int paramReliability) {
        this.risk = paramRisk;
        this.reliability = paramReliability;
    }

    public void setAlert(String paramAlert) {
        this.alert = new String(paramAlert);
    }

    public void setDetail(String paramDesc, String paramUri, String paramParam, String paramOtherInfo, String paramSolution, String paramReference) {
        this.setDesc(paramDesc);
        this.setUri(paramUri);
        this.setParam(paramParam);
        this.setOtherInfo(paramOtherInfo);
        this.setSolution(paramSolution);
        this.setReference(paramReference);
    }

    public void setUri(String paramUri) {
        this.uri = new String(paramUri);
    }

    public void setDesc(String paramDesc) {
        this.desc = new String(paramDesc);
    }

    public void setParam(String paramParam) {
        this.param = new String(paramParam);
    }

    public void setOtherInfo(String paramOtherInfo) {
        this.otherInfo = new String(paramOtherInfo);
    }

    public void setSolution(String paramSolution) {
        this.solution = new String(paramSolution);
    }

    public void setReference(String paramReference) {
        this.reference = new String(paramReference);
    }

    public int compareTo(Object o2) throws ClassCastException {
        AlertItem alert2 = (AlertItem)o2;
        int result = 0;
        if (this.risk < alert2.risk) {
            return -1;
        }
        if (this.risk > alert2.risk) {
            return 1;
        }
        if (this.reliability < alert2.reliability) {
            return -1;
        }
        if (this.reliability > alert2.reliability) {
            return 1;
        }
        result = this.alert.compareToIgnoreCase(alert2.alert);
        if (result != 0) {
            return result;
        }
        result = this.alert.compareToIgnoreCase(alert2.uri);
        if (result != 0) {
            return result;
        }
        result = this.alert.compareToIgnoreCase(alert2.param);
        if (result != 0) {
            return result;
        }
        return this.otherInfo.compareToIgnoreCase(alert2.otherInfo);
    }

    public boolean equals(Object obj) {
        AlertItem item = null;
        if (obj instanceof AlertItem) {
            item = (AlertItem)obj;
            if (this.id == item.id && this.uri.equalsIgnoreCase(item.uri) && this.param.equalsIgnoreCase(item.param) && this.otherInfo.equalsIgnoreCase(item.otherInfo)) {
                return true;
            }
        }
        return false;
    }

    public AlertItem newInstance() {
        AlertItem item = new AlertItem(this.id);
        item.setRiskReliability(this.risk, this.reliability);
        item.setAlert(this.alert);
        item.setDetail(this.desc, this.uri, this.param, this.otherInfo, this.solution, this.reference);
        return item;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer(150);
        sb.append("<alertitem>\r\n");
        sb.append("<alertid>" + this.id + "</alertid>");
        sb.append("<alert>" + this.alert + "</alert>");
        sb.append("<riskcode>" + this.risk + "</riskcode>");
        sb.append("<reliability>" + this.reliability + "</reliability>");
        sb.append("<riskdesc>" + this.replaceEntity(String.valueOf(MSG_RISK[this.risk]) + " (" + MSG_RELIABILITY[this.reliability] + ")") + "</riskdesc>");
        sb.append("<desc>" + this.paragraph(this.replaceEntity(this.desc)) + "</desc>");
        sb.append("<uri>" + this.paragraph(this.replaceEntity(this.uri)) + "</uri>");
        sb.append("<param>" + this.paragraph(this.replaceEntity(this.param)) + "</param>");
        sb.append("<otherinfo>" + this.paragraph(this.replaceEntity(this.otherInfo)) + "</otherinfo>");
        sb.append("<solution>" + this.paragraph(this.replaceEntity(this.solution)) + "</solution>");
        sb.append("<reference>" + this.paragraph(this.replaceEntity(this.reference)) + "</reference>");
        sb.append("</alertitem>\r\n");
        return sb.toString();
    }

    private String replaceEntity(String text) {
        String result = null;
        if (text != null) {
            result = text;
            result = Report.entityEncode(text);
        }
        return result;
    }

    private String paragraph(String text) {
        String result = null;
        result = text.replaceAll("\\r\\n", "<br/>").replaceAll("\\n", "<br/>");
        return result;
    }
}

