/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.network.HttpStatusCode;
import com.proofsecure.paros.scan.TestAbstractParam;
import java.io.IOException;
import java.util.regex.Pattern;

class TestPerlInjection
extends TestAbstractParam {
    private static String PERL_1 = ";ls%20/";
    private static String PERL_DELAY_1 = "';wait%2015;#";
    private static String PERL_DELAY_2 = ";wait%2015;#";
    private static int TIME_SPREAD = 15000;
    private static Pattern patternErrorPERL1 = Pattern.compile("insecure dependency", 42);
    private static Pattern patternErrorPERL2 = Pattern.compile("insecure \\$ENV\\{PATH\\}", 42);
    private String mResBodyNormal = "";

    TestPerlInjection() {
    }

    public String toString() {
        return "TestPerlInjection";
    }

    public String getTestName() {
        return "Perl Injection";
    }

    protected void check(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {
        String bingoQuery = null;
        String displayURI = null;
        String newQuery = null;
        String resBody = null;
        boolean pos = false;
        long defaultTimeUsed = 0L;
        long timeUsed = 0L;
        long lastTime = 0L;
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        defaultTimeUsed = System.currentTimeMillis() - lastTime;
        if (this.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        this.mResBodyNormal = this.getResponseBody().toString();
        bingoQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + PERL_1);
        this.createMessage(isBody, bingoQuery);
        this.sendAndReceive();
        displayURI = this.getRequestHeader().getURIHostPathQuery();
        if (this.checkResult(bingoQuery)) {
            return;
        }
        if (this.mResBodyNormal.indexOf("root") > 0 && (resBody = this.getResponseBody().toString()).indexOf("root") > 0) {
            this.bingo(20003, 3, 2, displayURI, bingoQuery, "");
        }
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + PERL_DELAY_1);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        timeUsed = System.currentTimeMillis() - lastTime;
        if (this.checkTimeResult(newQuery, defaultTimeUsed, timeUsed)) {
            return;
        }
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + PERL_DELAY_2);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        timeUsed = System.currentTimeMillis() - lastTime;
        if (this.checkTimeResult(newQuery, defaultTimeUsed, timeUsed)) {
            return;
        }
    }

    private boolean checkResult(String query) {
        StringBuffer sb = new StringBuffer();
        if (this.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(this.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (this.matchBodyPattern(patternErrorPERL1, sb) || this.matchBodyPattern(patternErrorPERL2, sb)) {
            this.bingo(20003, 3, 2, this.getRequestHeader().getURIHostPathQuery(), query, sb.toString());
            return true;
        }
        return false;
    }

    private boolean checkTimeResult(String query, long defaultTimeUsed, long timeUsed) {
        boolean result = this.checkResult(query);
        if (result) {
            return result;
        }
        if (timeUsed > defaultTimeUsed + (long)TIME_SPREAD - 500L) {
            this.bingo(20003, 3, 1, "", query, "");
            return true;
        }
        return false;
    }

    protected void scan() throws Exception {
        boolean skip = this.getEntity().mState == 1;
        this.writeStatus("PERL Injection: " + (skip ? "(skipped) " : "") + this.getRequestHeader().getURIHostPath());
        if (skip) {
            return;
        }
        this.init();
        this.checkUrlOrBody(false, this.myQuery);
        this.checkUrlOrBody(true, this.myReqBody.toString());
    }
}

