/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.spider;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;

class Website {
    URI mURI;
    String mSiteName;
    int mPort;
    Vector mUrlHistory;
    Vector mOtherSiteUrl = new Vector();
    Vector mServerType;
    Vector mCookies;
    Vector mAuth;

    Website(String s) {
        this.mUrlHistory = new Vector();
        try {
            this.mURI = new URI(s);
            if (!this.mURI.isAbsolute()) {
                this.mURI = new URI("http://localhost/").resolve(this.mURI);
            }
            this.mSiteName = this.mURI.getHost();
            this.mPort = this.mURI.getPort();
            if (this.mPort == -1) {
                if (this.mURI.toURL().getProtocol().equalsIgnoreCase("http")) {
                    this.mPort = 80;
                } else if (this.mURI.toURL().getProtocol().equalsIgnoreCase("http")) {
                    this.mPort = 443;
                }
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage());
        }
    }

    public String getSimplifiedHostURL() {
        String s = null;
        try {
            s = String.valueOf(this.mURI.toURL().getProtocol()) + "://" + this.mSiteName + ":" + this.mPort + "/";
        }
        catch (MalformedURLException e) {
            this.logError(e.getMessage());
        }
        return s;
    }

    public URI getURI() {
        return this.mURI;
    }

    public Vector getHistory() {
        return this.mUrlHistory;
    }

    public void addLink(URI uri) {
        if (!uri.isAbsolute()) {
            uri = this.mURI.resolve(uri);
        }
        if (this.mUrlHistory.indexOf(uri) == -1) {
            this.mUrlHistory.add(uri);
        }
    }

    public Vector getOtherLink() {
        return this.mOtherSiteUrl;
    }

    public void addOtherLink(URI uri) {
        if (this.mOtherSiteUrl.indexOf(uri) == -1) {
            this.mOtherSiteUrl.add(uri);
        }
    }

    public void clearOtherLink() {
        this.mOtherSiteUrl.clear();
    }

    private void list(Vector v) {
        int i = 0;
        while (i < v.size()) {
            System.out.println("list: " + (String)v.elementAt(i));
            ++i;
        }
    }

    protected Vector resolveURI(Vector vector, URI baseURI) {
        Vector<String> result = new Vector<String>();
        try {
            int i = 0;
            while (i < vector.size()) {
                URI uri = vector.elementAt(i) instanceof URL ? new URI(((URL)vector.elementAt(i)).toExternalForm()) : (vector.elementAt(i) instanceof URI ? (URI)vector.elementAt(i) : new URI((String)vector.elementAt(i)));
                if (!uri.isAbsolute()) {
                    uri = baseURI.resolve(uri);
                }
                if (uri.getScheme().toLowerCase().startsWith("http")) {
                    if (uri.getHost().toLowerCase().equals(this.mSiteName.toLowerCase())) {
                        result.add(uri.toString());
                        this.addLink(uri);
                    } else {
                        this.addOtherLink(uri);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.logError("Error: " + e.getMessage());
        }
        return result;
    }

    public void buildTree() {
    }

    public String toString() {
        return this.mURI.toString();
    }

    public void logError(String s) {
        System.out.println(s);
    }

    public String getRequestHeader() {
        String s = null;
        return s;
    }

    public static String URItoString(URI u) {
        return u.toString();
    }

    public static String URLtoString(URL u) {
        return u.toExternalForm();
    }

    public static URI StringtoURI(String s) throws URISyntaxException {
        return new URI(s);
    }

    public static URL StringtoURL(String s) throws MalformedURLException {
        return new URL(s);
    }

    public static URL URItoURL(URI u) throws MalformedURLException {
        return u.toURL();
    }

    public static URI URLtoURI(URL u) throws URISyntaxException {
        return new URI(u.toExternalForm());
    }

    public static String getLinkDirectory(URI uri) {
        String s = uri.toString();
        int i = -1;
        i = s.lastIndexOf("/");
        if (i != -1) {
            return s.substring(0, i + 1);
        }
        return null;
    }
}

