/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.ui;

import com.proofsecure.paros.util.Base64;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class EncodeDialog
extends JDialog {
    private static final String CODEPAGE = "8859_1";
    private JButton btnSHA1;
    private JButton btnMD5;
    private JButton btnBase64Encode;
    private JButton btnBase64Decode;
    private JButton btnURLEncode;
    private JButton btnURLDecode;
    private JButton btnCancel;
    private JTextArea txtEncode;
    private JTextArea txtDecode;
    private JLabel jLabelEncode;
    private JLabel jLabelDecode;
    private JScrollPane jScrollEncode = new JScrollPane();
    private JScrollPane jScrollDecode = new JScrollPane();

    public EncodeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.btnSHA1 = new JButton("SHA1 hash");
        this.btnMD5 = new JButton("MD5 hash");
        this.btnBase64Encode = new JButton("Base64 encode");
        this.btnBase64Decode = new JButton("Base64 decode");
        this.btnURLEncode = new JButton("URL encode");
        this.btnURLDecode = new JButton("URL deccode");
        this.jLabelEncode = new JLabel("Enter plain text below for hashing/encoding:");
        this.jLabelDecode = new JLabel("Enter encoded text below for decoding:");
        this.txtEncode = new JTextArea();
        this.txtEncode.setLineWrap(true);
        this.txtEncode.setColumns(32);
        this.txtEncode.setRows(5);
        this.txtDecode = new JTextArea();
        this.txtDecode.setLineWrap(true);
        this.txtDecode.setColumns(32);
        this.txtDecode.setRows(5);
        this.jScrollEncode.getViewport().add((Component)this.txtEncode, null);
        this.jScrollDecode.getViewport().add((Component)this.txtDecode, null);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Paros 3.1.2 ");
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EncodeDialog.this.closeDialog(evt);
            }
        });
        this.btnSHA1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EncodeDialog.this.btnSHA1ActionPerformed(evt);
            }
        });
        this.btnMD5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EncodeDialog.this.btnMD5ActionPerformed(evt);
            }
        });
        this.btnBase64Encode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EncodeDialog.this.btnBase64EncodeActionPerformed(evt);
            }
        });
        this.btnBase64Decode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EncodeDialog.this.btnBase64DecodeActionPerformed(evt);
            }
        });
        this.btnURLDecode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EncodeDialog.this.btnURLDecodeActionPerformed(evt);
            }
        });
        this.btnURLEncode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EncodeDialog.this.btnURLEncodeActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 18;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnSHA1, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnMD5, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnBase64Encode, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnURLEncode, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnBase64Decode, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnURLDecode, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabelEncode, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabelDecode, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.gridheight = 3;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 0.7;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jScrollEncode, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.gridheight = 3;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 0.7;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jScrollDecode, gridBagConstraints1);
        this.pack();
    }

    private void btnMD5ActionPerformed(ActionEvent evt) {
        byte[] md5 = null;
        this.txtDecode.setText("");
        try {
            md5 = this.getHashMD5(this.txtEncode.getText().getBytes(CODEPAGE));
            this.txtDecode.setText(this.getHexString(md5));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnSHA1ActionPerformed(ActionEvent evt) {
        byte[] sha = null;
        this.txtDecode.setText("");
        try {
            sha = this.getHashSHA1(this.txtEncode.getText().getBytes(CODEPAGE));
            this.txtDecode.setText(this.getHexString(sha));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnBase64EncodeActionPerformed(ActionEvent evt) {
        String result = "";
        try {
            result = Base64.encodeBytes(this.getBytes(this.txtEncode.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.txtDecode.setText(result);
    }

    private void btnBase64DecodeActionPerformed(ActionEvent evt) {
        byte[] result = null;
        this.txtEncode.setText("");
        if (!this.isValidBase64(this.txtDecode.getText())) {
            return;
        }
        try {
            result = Base64.decode(this.txtDecode.getText());
            this.txtEncode.setText(new String(result, CODEPAGE));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.txtEncode.setText("");
        this.txtDecode.setText("");
    }

    private byte[] getHashSHA1(byte[] buf) throws NoSuchAlgorithmException {
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        sha.update(buf);
        return sha.digest();
    }

    private byte[] getHashMD5(byte[] buf) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buf);
        return md5.digest();
    }

    private String getHexString(byte[] buf) {
        StringBuffer sb = new StringBuffer(20);
        int i = 0;
        while (i < buf.length) {
            int digit = buf[i] & 0xFF;
            String hexDigit = Integer.toHexString(digit).toUpperCase();
            if (hexDigit.length() == 1) {
                sb.append('0');
            }
            sb.append(hexDigit);
            ++i;
        }
        return sb.toString();
    }

    private byte[] getBytes(String buf) throws UnsupportedEncodingException {
        return buf.getBytes(CODEPAGE);
    }

    private boolean isValidBase64(String buf) {
        String result = Base64.encodeBytes(Base64.decode(buf));
        return buf.equals(result);
    }

    private void btnURLDecodeActionPerformed(ActionEvent evt) {
        this.txtEncode.setText("");
        try {
            String result = URLDecoder.decode(this.txtDecode.getText(), "UTF8");
            this.txtEncode.setText(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnURLEncodeActionPerformed(ActionEvent evt) {
        this.txtDecode.setText("");
        try {
            String result = URLEncoder.encode(this.txtEncode.getText(), "UTF8");
            this.txtDecode.setText(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

