/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.util;

import com.proofsecure.paros.network.ConnectorConfig;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Config
implements ConnectorConfig {
    private static final String PROXY_SERVER = "ProxyServer";
    private static final String PORT = "Port";
    private static final String PROXY_CHAIN = "ProxyChain";
    private static final String SCANNER = "Scanner";
    private static final String[] PATH_PROXY_IP = new String[]{"ProxyServer", "IP"};
    private static final String[] PATH_PROXY_PORT = new String[]{"ProxyServer", "Port"};
    private static final String[] PATH_PROXY_PORT_SSL = new String[]{"ProxyServer", "SSL"};
    private static final String[] PATH_PROXY_CHAIN_NAME = new String[]{"ProxyChain", "Name"};
    private static final String[] PATH_PROXY_CHAIN_PORT = new String[]{"ProxyChain", "Port"};
    private static final String[] PATH_PROXY_CHAIN_SKIP = new String[]{"ProxyChain", "Skip"};
    private static final String[] PATH_PROXY_CHAIN_USER = new String[]{"ProxyChain", "User"};
    private static final String[] PATH_PROXY_CHAIN_PASSWORD = new String[]{"ProxyChain", "Password"};
    private static final String[] PATH_SCANNER_THREAD = new String[]{"Scanner", "Thread"};
    private Document mDoc = null;
    private DocumentBuilderFactory mFactory = null;
    private DocumentBuilder mBuilder = null;
    private Pattern patternSkip = null;

    public Config() {
        try {
            this.mFactory = DocumentBuilderFactory.newInstance();
            this.mFactory.setValidating(false);
            this.mBuilder = this.mFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public void read(String fileName) throws SAXException, IOException {
        this.mDoc = this.mBuilder.parse(fileName);
        this.processConfig();
    }

    public void processConfig() {
        this.parseProxyChainSkip();
    }

    public void main(String[] args) {
    }

    private Element getElement(String[] path) {
        NodeList nodes = this.mDoc.getElementsByTagName(path[0]);
        Element ele = (Element)nodes.item(0);
        int i = 1;
        while (i < path.length) {
            nodes = ele.getElementsByTagName(path[i]);
            ele = (Element)nodes.item(0);
            ++i;
        }
        return ele;
    }

    private String getText(Element element) {
        int i = 0;
        while (i < element.getChildNodes().getLength()) {
            Node node = element.getChildNodes().item(i);
            if (node.getNodeType() == 3) {
                return node.getNodeValue();
            }
            ++i;
        }
        return "";
    }

    private void setText(Element element, String text) {
        int i = 0;
        while (i < element.getChildNodes().getLength()) {
            Node node = element.getChildNodes().item(i);
            if (node.getNodeType() == 3) {
                node.setNodeValue(text);
                return;
            }
            ++i;
        }
    }

    public String getProxyIP() {
        String ip = "127.0.0.1";
        try {
            ip = this.getText(this.getElement(PATH_PROXY_IP));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    public int getProxyPort() {
        int port = 8080;
        try {
            port = Integer.parseInt(this.getText(this.getElement(PATH_PROXY_PORT)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public int getProxyPortSSL() {
        int port = 8443;
        try {
            port = Integer.parseInt(this.getText(this.getElement(PATH_PROXY_PORT_SSL)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public boolean isUseProxyChain() {
        boolean result = false;
        try {
            if (!this.getText(this.getElement(PATH_PROXY_CHAIN_NAME)).trim().equals("")) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getProxyChainName() {
        String ip = "127.0.0.1";
        try {
            ip = this.getText(this.getElement(PATH_PROXY_CHAIN_NAME)).trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    public int getProxyChainPort() {
        int port = 8080;
        try {
            port = Integer.parseInt(this.getText(this.getElement(PATH_PROXY_CHAIN_PORT)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public boolean isSkipProxyChain(String hostName) {
        if (this.patternSkip == null || hostName == null) {
            return false;
        }
        return this.patternSkip.matcher(hostName).find();
    }

    public String getProxyChainUser() {
        String user = "";
        try {
            user = this.getText(this.getElement(PATH_PROXY_CHAIN_USER));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user;
    }

    public String getProxyChainPassword() {
        String pass = "";
        try {
            pass = this.getText(this.getElement(PATH_PROXY_CHAIN_PASSWORD));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pass;
    }

    public boolean useProxy(String hostName) {
        return this.isUseProxyChain() && !this.isSkipProxyChain(hostName);
    }

    private void parseProxyChainSkip() {
        String skipNames = "";
        this.patternSkip = null;
        try {
            skipNames = this.getText(this.getElement(PATH_PROXY_CHAIN_SKIP)).trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (skipNames.equals("")) {
            return;
        }
        skipNames = skipNames.replaceAll("\\*", "\\w*").replaceAll("(;+$)|(^;+)", "");
        skipNames = "(" + skipNames.replaceAll(";+", "|") + ")$";
        this.patternSkip = Pattern.compile(skipNames);
    }

    public int getScannerThread() {
        int thread = 5;
        try {
            thread = Integer.parseInt(this.getText(this.getElement(PATH_SCANNER_THREAD)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return thread;
    }
}

