/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.util;

public class SerialCounter {
    int mNextNewSerial = 1;
    int mCurrentSerial = 1;

    public synchronized int getNextSerial() {
        int result = this.mNextNewSerial++;
        return result;
    }

    public synchronized void waitForTurn(int mySerial, int timeOutMillis) {
        long startTime;
        long now = startTime = System.currentTimeMillis();
        while (mySerial > this.mCurrentSerial) {
            try {
                this.wait(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
            if (startTime + (long)timeOutMillis >= now) continue;
            this.mCurrentSerial = mySerial;
            this.notifyAll();
            break;
        }
    }

    public synchronized void setTurn(int mySerial) {
        if (mySerial >= this.mCurrentSerial) {
            this.mCurrentSerial = mySerial == this.mCurrentSerial ? this.mCurrentSerial + 1 : mySerial;
            this.notifyAll();
        }
    }

    public int getCurrentSerial() {
        return this.mCurrentSerial;
    }
}

