/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

import javax.net.ssl.SSLContext;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import com.proofsecure.paros.log.DumpRequestPanel;
import com.proofsecure.paros.log.DumpResponsePanel;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpConnection;
import com.proofsecure.paros.network.HttpConnectionPool;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.network.SSLConnector;

public class ManualTester extends javax.swing.JFrame{
	private static final int FRAME_HEIGHT = 480;
	private static final int FRAME_WIDTH = 640;
	private static final String FRAME_NAME = "Send HTTP(S) request";
	private DumpRequestPanel dumpRequestPanel = new DumpRequestPanel(true);
	private DumpResponsePanel dumpResponsePanel = new DumpResponsePanel();
	protected URLConnection conn = null;
	protected HttpURLConnection hconn = null;
	protected HttpRequestHeader reqHeader = null;
	protected SSLContext sc;
	protected boolean mSecureFlag = false;
	
	/** Creates new form Tester */
	public ManualTester() {
		initComponents();
	}
	
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents() {

		setIconImage(Toolkit.getDefaultToolkit().createImage("paros_logo.gif"));

		this.setSize(new Dimension(FRAME_WIDTH, FRAME_HEIGHT));
		this.setTitle(FRAME_NAME);
		
		
		jPanel1 = new javax.swing.JPanel();
		jLabel1 = new javax.swing.JLabel();
		jLabel2 = new javax.swing.JLabel();
		jTextField1 = new javax.swing.JTextField();
		jTextField2 = new javax.swing.JTextField();
		jButton1 = new javax.swing.JButton();
		jTabbedPane1 = new javax.swing.JTabbedPane();

		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(final java.awt.event.ActionEvent evt) {
						btnClickActionPerformed(evt);			
			}
		});
		
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				//exitForm(evt);
				//hide();
				dispose();
			}
		});

		
		jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.X_AXIS));

		jLabel1.setText("HTTP(S) + Domain:");
		jPanel1.add(jLabel1);

		jTextField1.setText("http://");
		jPanel1.add(jTextField1);

		jLabel2.setText("  Port:");
		jPanel1.add(jLabel2);
		jTextField2.setText("80");
		jPanel1.add(jTextField2);

		jButton1.setText("Send");
		jPanel1.add(jButton1);
		jTabbedPane1.addTab("Request", dumpRequestPanel);
		jTabbedPane1.addTab("Response", dumpResponsePanel);
		
		getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);

		getContentPane().add(jTabbedPane1, java.awt.BorderLayout.CENTER);

		dumpRequestPanel.setMessage("GET / HTTP/1.0", "");
		pack();
	}
	
	/** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt) {
		System.exit(0);
	}

	public void show(Dimension parentSize){
		
		Dimension frameSize = this.getPreferredSize();
		
		if (parentSize == null){
			// get the desktop screen size
			parentSize = Toolkit.getDefaultToolkit().getScreenSize();
		}
		
		if (frameSize.height > parentSize.height) {
			frameSize.height = parentSize.height;
		}
		if (frameSize.width > parentSize.width) {
			frameSize.width = parentSize.width;
		}
		
		this.setLocation((parentSize.width - frameSize.width) / 2, (parentSize.height - frameSize.height) / 2);
		
		this.pack();
		this.show();  	
	}
	
	
	public DumpRequestPanel getRequestPanel(){
		return dumpRequestPanel;
	}


	protected void setHeaderProperty(URLConnection conn, HttpRequestHeader req) {
		String[] reqlines = req.toString().split("\r\n");
		int index = 0;
		for (int i=0;i<reqlines.length;i++){
			if (i==0 && (reqlines[i].startsWith("GET")||
					reqlines[i].startsWith("HEAD")||
					reqlines[i].startsWith("OPTIONS")||
					reqlines[i].startsWith("POST")||
					reqlines[i].startsWith("PUT")||
					reqlines[i].startsWith("DELETE")||
					reqlines[i].startsWith("TRACE")||
					reqlines[i].startsWith("CONNECT"))){
				continue;
			}
			if ((index = reqlines[i].indexOf(" "))!=-1){
				conn.setRequestProperty(reqlines[i].substring(0,index-1), reqlines[i].substring(index+1));			
			}
				
		}	
	}
	public void setSecure(boolean s) {
		mSecureFlag = s;
	}

	private String getContent(BufferedInputStream in) {
		int len = 0;
		byte[] buf = new byte[1024];
		StringBuffer body = new StringBuffer();
		try {
			while (len >= 0) {

				len = in.read(buf);
				if (len > 0) {
					String temp = null;
					try {
						temp = new String(buf, 0, len, "8859_1");
					} catch (Exception e) {
						temp = new String(buf, 0, len);
					}
					body.append(temp);
				} else {
					break;
				}
			}
		} catch (IOException e) {
		}

		return body.toString();

	}

	
	private void sendAndReceive(String url) throws IOException, URISyntaxException {

		String hostName;
		int port;
		boolean isSecure = false;
		boolean isUseClientCert = false;
		String header= dumpRequestPanel.getHeader();
		String body = dumpRequestPanel.getBody();
		
		
		URI aur = new URI(url);
		if (!aur.isAbsolute()) {
			//aur = new URI(jTextField1.getText()).resolve(aur);
			System.out.println("Error: URL field incorrect.");
			return;
		}
		URL ur = aur.toURL();

		String proto = ur.getProtocol();

		if (!proto.equalsIgnoreCase("http")
				&& !proto.equalsIgnoreCase("https")) {
//			System.out.println(USAGE);
			return;
		}
		if (proto.equalsIgnoreCase("https")){
			this.setSecure(true);
			isSecure = true;
		}

		//  code begin

		SSLConnector ssl 		= Global.ssl;
		com.proofsecure.paros.util.Config config = Global.config;
			
		HttpRequestHeader reqHeader = null;
		HttpBody reqBody = null;
		HttpResponseHeader resHeader = null;
		HttpBody resBody = null;
		HttpConnectionPool pool = new HttpConnectionPool(config, ssl);
		HttpConnection hconn = null;
		boolean absoluteUriRequired = false;
			
		reqHeader = new HttpRequestHeader(header);
		reqBody = new HttpBody(body);

		hostName = aur.getHost();
		//port = aur.getPort();
		port = Integer.parseInt(jTextField2.getText());
		
		if (port==-1){
			if (isSecure)
				port = 443;
			else
				port = 80;
		}
//			System.out.println(hostName + " " +  port);
		hconn = pool.connect(hostName, port, isSecure, isUseClientCert);
		
		if (!isSecure && config.useProxy(hostName)) {
			absoluteUriRequired = true;
		}

		reqHeader.setAbsoluteUriRequired(absoluteUriRequired);
		reqHeader.setContentLength(reqBody.length());
//		System.out.println(reqHeader);
		hconn.mHttpOut.write(reqHeader);
		hconn.mHttpOut.write(reqBody);
		
		resHeader = (HttpResponseHeader) hconn.mHttpIn.readHeader();
		resBody = (HttpBody) hconn.mHttpIn.readBody();
		
		dumpResponsePanel.setMessage(resHeader.toString(), resBody.toString());
		
		pool.close();
		// code end
		
		return ;

	}
	
	private void btnClickActionPerformed(java.awt.event.ActionEvent evt) {
		dumpResponsePanel.setMessage("","");
		jTabbedPane1.setSelectedIndex(jTabbedPane1.indexOfTab("Response"));				
	    SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {
					sendAndReceive(jTextField1.getText());
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (URISyntaxException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
          	}
      	});
				
	}

	public void setProxy(String proxyhost, String proxyport) {
		//    if (mSecureFlag){
		System.getProperties().setProperty("https.proxyHost", proxyhost);
		System.getProperties().setProperty("https.proxyPort", proxyport);
		//    }
		//    else{
		System.getProperties().setProperty("http.proxyHost", proxyhost);
		System.getProperties().setProperty("http.proxyPort", proxyport);
		//    }
	}
	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		ManualTester tester = new ManualTester();
		tester.setProxy("localhost","8080");
		tester.getRequestPanel().setMessage("GET / HTTP/1.0", "");
		tester.show();
	}
	
	// Variables declaration - do not modify
	private javax.swing.JButton jButton1;
	private javax.swing.JComboBox jComboBox1;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JTabbedPane jTabbedPane1;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JTextField jTextField1;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JTextField jTextField2;

	/**
	 * 
	 * @param header
	 * @param body
	 * @param httpsFlag
	 * @param domain
	 * @param port
	 */
	public void initValue(String header, String body, boolean httpsFlag, String domain, int port) {
		dumpRequestPanel.setMessage(header, body);
		jTextField1.setText("" + domain);
		jTextField2.setText("" + port);		
		setSecure(httpsFlag);		
	}
	// End of variables declaration
	
}
