/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros;
 
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

import com.proofsecure.paros.log.*;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpConnection;
import com.proofsecure.paros.network.HttpConnectionPool;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpInputStream;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpOutputStream;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.network.HttpStatusCode;
import com.proofsecure.paros.ui.ParosFrame;
import com.proofsecure.paros.util.SerialCounter;
import com.proofsecure.paros.util.Util;


class ProxyHandler implements Runnable {


	protected static final byte[] CONNECT_HTTP_200 = "HTTP/1.0 200 Connection established\r\nProxy-Connection: Close\r\n\r\n".getBytes();
	protected static Vector tunnelProcessList = new Vector();
	protected static java.text.DecimalFormat decimalFormat = new java.text.DecimalFormat("##0.###");

	protected static final int		BUFFEREDSTREAM_SIZE = 4096;
	
	protected static SerialCounter counter = new SerialCounter();
	protected static java.text.DecimalFormat decFormat = new java.text.DecimalFormat("##0.###");

	private int count = 0;

   	protected Socket 				mInSocket = null,
									mOutSocket = null;
	protected boolean 				disconnect = false;
	protected HttpInputStream		mClientHttpIn = null,
									mHostHttpIn = null;
	protected HttpOutputStream		mClientHttpOut = null,
									mHostHttpOut = null;
	protected HttpRequestHeader 	mClientHttpInReqHeader = null;
	protected HttpResponseHeader 	mHostHttpInResHeader = null;
	protected HttpBody				mClientHttpInReqBody = null,
									mHostHttpInResBody = null;
	BufferedInputStream				tunnel_in	= null;
	BufferedOutputStream			tunnel_out	= null;

	protected HttpConnection		mConn		= null;
	protected HttpConnectionPool	mPool		= null;
	
	protected String				mHostName = "";			//	outgoing host name
	protected int					mHostPort = 0;			//	outgoing host port
	protected boolean				isUseAbsolueteUri= false;	//	require via proxy for the header	
	
	protected Thread 				myThread = null;
	protected ProxyHandler 			mOriginHandler = null;
	
	protected boolean				httpsFlag = false;

	ProxyHandler() {

		myThread = new Thread(this);
		myThread.setDaemon(true);
		mOriginHandler = this;
	}

	public void start(Socket sock) {
		mInSocket = sock;
	    try {
	    	mInSocket.setSoTimeout(60000);
	    } catch (SocketException e) {
	    }

		myThread.start();

	}

	public void start(Socket sock, boolean flag) {
		httpsFlag = flag;
		mInSocket = sock;
	    try {
	    	mInSocket.setSoTimeout(60000);
	    } catch (SocketException e) {
	    }

		myThread.start();
	}
	
	public boolean isAlive() {
		return myThread.isAlive();
	}
	
	public Thread getThread() {
		return myThread;
	}

	public void run() {

		process();

		//	place all final call, clean up here.
		disconnect();
		if (count != 0) {
			counter.setTurn(count);
		}
		
	}
	
	protected void process() {
		http();
	}
	
	private void http() {

		try {
			mClientHttpIn = new HttpInputStream(mInSocket.getInputStream());
			mClientHttpOut = new HttpOutputStream(mInSocket.getOutputStream());
			mClientHttpInReqHeader = (HttpRequestHeader) mClientHttpIn.readHeader();

			//assumeProxy();
			afterRequestHeaderRead(mClientHttpInReqHeader);

			if (mClientHttpInReqHeader.getMethod().equalsIgnoreCase(HttpRequestHeader.CONNECT)) {
				mClientHttpOut.write(CONNECT_HTTP_200);
				processViaTunnel();
			} else {
				if (isTrapEnabled() || mClientHttpInReqHeader.isHttp10()) {
					processDirectHttp10();
				} else {
					processDirectHttp11();
				}
			}
		} catch (HttpMalformedHeaderException e) {
			try {
				HttpResponseHeader errResponse = HttpResponseHeader.getError(HttpResponseHeader.HTTP_CLIENT_BAD_REQUEST);
				mClientHttpOut.write(errResponse);
				mClientHttpOut.flush();
			} catch (IOException ioe) {
			}

			showErrMessage("Malformed HTTP header from client.");

		} catch (IOException ioe) {
			showErrMessage("Error: " + ioe.getMessage() + ". connection closed");
//			ioe.printStackTrace();
		} catch (Exception e) {
			showErrMessage("Error: " + e.getMessage());
		}
		

	}

	private synchronized void processAdmin() throws Exception{
		String LOCALHOST = "127.0.0.1";

		// check IP rules set in AdminServer, and allow only SSL connection to AdminPage
		if (!Global.adminServer.isAccessAllowed(mInSocket) || httpsFlag==false){
			disconnect();
			return;
		}
		
		// add an authCode which is obtain from AdminServer,
		// so AdminServer can distinguish the connection between direct access or via Proxy 
		// All direct access will be rejected by AdminServer
		mClientHttpInReqHeader.setHostName(LOCALHOST);
		mClientHttpInReqHeader.setHeader("Host", LOCALHOST +":"+mClientHttpInReqHeader.getHostPort());
		mClientHttpInReqHeader.setHeader(Global.adminServer.getAuthCode(), "paros");		
		Global.parosFrame.setPanel(mClientHttpInReqHeader, mClientHttpInReqBody, mClientHttpInReqHeader.getURI(), true);
		mClientHttpInReqHeader.setContentLength(mClientHttpInReqBody.length());
		try {				
			mOutSocket = Util.connect(LOCALHOST, mClientHttpInReqHeader.getHostPort(), true);
			mHostHttpIn = new HttpInputStream(mOutSocket.getInputStream());
			mHostHttpOut = new HttpOutputStream(mOutSocket.getOutputStream());
		} catch (IOException ioe) {
//			ioe.printStackTrace();
			System.out.println("Error: " + ioe.getMessage());
			disconnect();
			return;				
		}

		mClientHttpInReqHeader.setAbsoluteUriRequired(isUseAbsoluteUri(mClientHttpInReqHeader.getHostName()));
		mHostHttpOut.write(mClientHttpInReqHeader);					
		mHostHttpOut.write(mClientHttpInReqBody);				

		Thread.yield();

		mHostHttpInResBody = null;
			mHostHttpInResHeader = 	(HttpResponseHeader) mHostHttpIn.readHeader();
//			beforeResponseHeaderWrite(mHostHttpInResHeader);
		mHostHttpInResBody = mHostHttpIn.readBody();

		Global.parosFrame.setPanel(mHostHttpInResHeader, mHostHttpInResBody, " " + mClientHttpInReqHeader.getURI(), false);
		mHostHttpInResHeader.setContentLength(mHostHttpInResBody.length());


		if (mHostHttpInResHeader != null)
			mClientHttpOut.write(mHostHttpInResHeader);
		if (mHostHttpInResBody != null)
			mClientHttpOut.write(mHostHttpInResBody);

		notifyWrittenToTunnel();

		
	}

	private void processDirectHttp10() throws Exception {

		long	sendTime = 0,
				diffTime = 0;
		String statusLog = "";
		String diffTimeString = "";
		mPool = new HttpConnectionPool(Global.config, Global.ssl);
		ConnectionQueueEntry queueEntry = null;

/* disable AdminServer
		boolean isWebLinkExisted = false;
		WebLink wl = null;
*/
        mClientHttpInReqHeader.setHeader(HttpHeader.CONNECTION, HttpHeader._CLOSE);
        mClientHttpInReqHeader.setHeader(HttpHeader.PROXY_CONNECTION, HttpHeader._CLOSE);

		mClientHttpInReqBody = mClientHttpIn.readBody();
		afterRequestBodyRead(mClientHttpInReqHeader, mClientHttpInReqBody);
		// always set request header to HTTP/1.0 as currently proxy cannot handle
		// server response with chunked encoding
		
		if (mClientHttpInReqHeader.isHttp11()) {
			mClientHttpInReqHeader.setVersion(HttpHeader.VERSION_HTTP10);
		}
/* AdminServer */
		// AdminServer request handling - check if the request is sent to Paros AdminServer
		// all AdminServer request should not be filtered, logged, or increment count
//		if (Global.isRunAdminServer && mHostPort == AdminServer.ADMIN_SERVER_PORT && mHostName.equalsIgnoreCase("paros")){
		if (Global.isRunAdminServer && mClientHttpInReqHeader.getHostPort() == AdminServer.ADMIN_SERVER_PORT && mClientHttpInReqHeader.getHostName().equalsIgnoreCase("paros")){
			processAdmin();
			return;			
		}
		

		// force correct URL display in panel
		mClientHttpInReqHeader.setAbsoluteUriRequired(isUseAbsoluteUri(mClientHttpInReqHeader.getHostName()));		
		
		// process header and body with enabled filters
		Global.filterManager.filterRequest(mClientHttpInReqHeader,mClientHttpInReqBody);


/* disable AdminServer
		// try to retrive weblink from cache, wl=null if weblink not exists in cache		
		if (mClientHttpInReqHeader.getMethod().equalsIgnoreCase("POST"))
			wl = (WebLink)Global.parosFrame.getLogLink(mClientHttpInReqHeader.getHostName(), mClientHttpInReqHeader.getPrimeHeader(),mClientHttpInReqBody.toString());
		else
			wl = (WebLink)Global.parosFrame.getLogLink(mClientHttpInReqHeader.getHostName(), mClientHttpInReqHeader.getPrimeHeader());

		if (!Global.isOffline || (Global.isOffline && wl==null)) {  // still get URL if URL not in cache
*/

			Global.parosFrame.setPanel(mClientHttpInReqHeader, mClientHttpInReqBody, mClientHttpInReqHeader.getURI(), true);
			mClientHttpInReqHeader.setContentLength(mClientHttpInReqBody.length());
           	Global.treePanel.setTree(mClientHttpInReqHeader, mClientHttpInReqBody);

			connectHost(mClientHttpInReqHeader);

			modifyHeaders(mClientHttpInReqHeader);
			mHostHttpOut.write(mClientHttpInReqHeader);					
			mHostHttpOut.write(mClientHttpInReqBody);

/* disable AdminServer
		}
*/
		queueEntry = new ConnectionQueueEntry(mConn);
		queueEntry.setRequest(mClientHttpInReqHeader, mClientHttpInReqBody, counter.getNextSerial());
		processRequestLog(queueEntry);


/* disable AdminServer
		// log weblink
		if (Global.isOffline && wl==null){
			// log the case for weblink not existed in cache under offline mode
			statusLog = "OFFLINE MODE: CANNOT FOUND =>" + (httpsFlag?"HTTPS ":"") + mClientHttpInReqHeader.getPrimeHeader();
			Global.parosFrame.setStatus(statusLog);					
			
		} else{
			statusLog = (Global.isOffline?"OFFLINE MODE: ":"") + (httpsFlag?"HTTPS ":"")  + mClientHttpInReqHeader.getPrimeHeader();
			Global.parosFrame.setStatus(statusLog);
		}
*/				
/*
			statusLog = (Global.isOffline?"OFFLINE MODE: ":"") + (httpsFlag?"HTTPS ":"")  + mClientHttpInReqHeader.getPrimeHeader();
			Global.parosFrame.setStatus(statusLog);
*/
/* disable AdminServer
		// check if weblink exists in cache
		if (wl==null){
		// test https and http difference
//			if (httpsFlag)
//			((ParosFrame)(Tools.gui)).logAppend("SSL!!!! " + mClientHttpInReqHeader.getPrimeHeader());

			wl = new WebLink(httpsFlag, mClientHttpInReqHeader.getPrimeHeader(),mClientHttpInReqHeader, mClientHttpInReqBody);

		} else {
			isWebLinkExisted = true;
		}
*/

/* disable AdminServer
		// do not allow to retrieve pages online if the URL did not exist in cache
		// You can comment out this to loose this constraint
		if (Global.isOffline && !isWebLinkExisted){
				disconnect();
				return;
		}
*/

		sendTime = System.currentTimeMillis();
		Thread.yield();

		mHostHttpInResBody = null;

/* disable AdminServer
		if (Global.isOffline && isWebLinkExisted){
			mHostHttpInResHeader = (HttpResponseHeader)(wl.getRespHeader());  //get resp. from offline storage					
		}
		else{
			mHostHttpInResHeader = 	(HttpResponseHeader) mHostHttpIn.readHeader();
		}
*/
		mHostHttpInResHeader = 	(HttpResponseHeader) mHostHttpIn.readHeader();

		beforeResponseHeaderWrite(mHostHttpInResHeader);

/* disable AdminServer
		if ((Global.isOffline && isWebLinkExisted)){ //|| mClientHttpInReqHeader.isImage()){
			// return cache response because weblink exists in cache
			mHostHttpInResBody = wl.getRespContent();
				
			if (mHostHttpInResHeader != null)
				mClientHttpOut.write(mHostHttpInResHeader);
			if (mHostHttpInResBody != null)
				mClientHttpOut.write(mHostHttpInResBody);
				
    } else 
*/    
    if (!mClientHttpInReqHeader.isImage() && ((mHostHttpInResHeader.isText() || (!mHostHttpInResHeader.isText() && mHostHttpInResHeader.getContentLength() < 512000)))) {
			mHostHttpInResBody = mHostHttpIn.readBody();
//			mHostHttpInResHeader.setHttpRequestHeader(mClientHttpInReqHeader);
 			Global.filterManager.filterResponse(mClientHttpInReqHeader, mHostHttpInResHeader, mHostHttpInResBody);

   		Global.parosFrame.setPanel(mHostHttpInResHeader, mHostHttpInResBody, diffTimeString + " " + mClientHttpInReqHeader.getURI(), false);
			mHostHttpInResHeader.setContentLength(mHostHttpInResBody.length());

			mClientHttpOut.write(mHostHttpInResHeader);
			mClientHttpOut.write(mHostHttpInResBody);

      	} else if (!mHostHttpInResHeader.isText() && !mClientHttpInReqHeader.isImage()){
			mHostHttpInResBody = new HttpBody("");
			Global.parosFrame.setPanel(mHostHttpInResHeader, null, diffTimeString + " " + mClientHttpInReqHeader.getURI(), false);

			mClientHttpOut.write(mHostHttpInResHeader);
			mHostHttpIn.pipeBody(mClientHttpOut);

		} else {
			mClientHttpOut.write(mHostHttpInResHeader);
			mHostHttpInResBody = mHostHttpIn.pipeBody(mClientHttpOut, true);
		}

		diffTime = System.currentTimeMillis() - sendTime;

/* disable AdminServer			
		if (Global.isOffline && !isWebLinkExisted){
			Global.isOffline  = false;
			Global.isOffline = true;
		}
*/

		writeOutputLog(queueEntry.mCount, mClientHttpInReqHeader, mHostHttpInResHeader, diffTime);
		
/* disable AdminServer			
		// Only cache the url with 2xx, and some 3xx status codes
		if (!isWebLinkExisted && (mHostHttpInResHeader.getStatusCode() < 401 || mHostHttpInResHeader.getStatusCode() >= 500) ){
			// save the newly retrived response in cache
			wl.setRespHeader(mHostHttpInResHeader);
			if (mHostHttpInResBody==null && mHostHttpIn != null){
				mHostHttpInResBody = mHostHttpIn.readBody();
			}

			if (mHostHttpInResBody!=null )
				wl.setRespContent(mHostHttpInResBody);
  			Global.parosFrame.setLogLink(wl);

		}
*/
		notifyWrittenToTunnel();

		writeResponseLog(queueEntry.mCount, mHostHttpInResHeader, mHostHttpInResBody);
	}

		


	private void processViaTunnel() {
		
		int len = 0;
		byte[] buf = new byte[BUFFEREDSTREAM_SIZE];
		boolean isError = false;
		long startTime = System.currentTimeMillis();
		
		setDisconnect(false);

		try {

			synchronized (tunnelProcessList) {
				mOutSocket = new Socket(Global.config.getProxyIP(),Global.config.getProxyPortSSL());
				mOutSocket.setTcpNoDelay(true);
				tunnelProcessList.add(this);
				//tunnel_out = new BufferedOutputStream(mOutSocket.getOutputStream(), BUFFEREDSTREAM_SIZE);
				//tunnel_in = new BufferedInputStream(mOutSocket.getInputStream(), BUFFEREDSTREAM_SIZE);
				tunnel_out = new BufferedOutputStream(mOutSocket.getOutputStream());
				tunnel_in = new BufferedInputStream(mOutSocket.getInputStream());

			}
		} catch (Exception e) {
			showErrMessage("Error connecting to internal SSL proxy.");
			isError = true;
		}

		try {
			do {
				if (isError) {
					break;
				}

				for (int i=0; i<2 && mClientHttpIn.available() > 0; i++) {
					len = mClientHttpIn.read(buf);
					if (len > -1) {
						tunnel_out.write(buf,0,len);
						tunnel_out.flush();
						startTime = System.currentTimeMillis();
					}
				}

				Thread.yield();
				synchronized(this) {
					try {
						if (tunnel_in.available() == 0) {
							wait(30);
						}
					} catch (InterruptedException e) {
					}
					
					for (int i=0; i<5 && tunnel_in.available() > 0; i++) {
						len = tunnel_in.read(buf);
						if (len > -1) {
							mClientHttpOut.write(buf,0,len);
							mClientHttpOut.flush();
							startTime = System.currentTimeMillis();
						}
					}
					if (tunnel_in.available() == 0) {
						setTunnelInputBufferEmpty(true);
					}
				}
			} while ((!isDisconnect() || !isTunnelInputBufferEmpty()) && System.currentTimeMillis() - startTime < 60000);

		} catch (Exception e) {
			showErrMessage("Error in tunnel: "+ e.getMessage());
		}

		removeFromList();	// end tunnel processing
		
		Util.closeInputStream(tunnel_in);
		Util.closeOutputStream(tunnel_out);		

	}

	protected void afterRequestHeaderRead(HttpRequestHeader req) {
		req.setSecure(false);
		mHostName = req.getHostName();
		mHostPort = req.getHostPort();
	}

	protected void afterRequestBodyRead(HttpRequestHeader req, HttpBody body) {
	}

	protected void beforeResponseHeaderWrite(HttpResponseHeader res) {
	}

	protected boolean isUseAbsoluteUri(String hostName) {
		boolean isSecure = false;

		if (this instanceof SSLProxyHandler) {
			isSecure = true;
		}

		if (!isSecure && Util.checkAndUseProxy(hostName)) {
			return true;
		}
		
		return false;
	}
	
	/**
	Create output socket.
	@return	socket created.  null = no socket created.
	*/
	private void connectHost(HttpRequestHeader req) throws IOException {
		
		mConn = mPool.connect(req.getHostName(), req.getHostPort(), req.getSecure(), Global.isUseClientCert);

		mOutSocket = mConn.mSocket;
		mHostHttpIn = mConn.mHttpIn;
		mHostHttpOut = mConn.mHttpOut;

	}

	protected void removeFromList() {
		synchronized (tunnelProcessList) {
			tunnelProcessList.remove(this);
		}
	}

	protected synchronized boolean isDisconnect() {
		return disconnect;
	}

	protected synchronized void setDisconnect(boolean flag) {
		disconnect = flag;
	}

	/**
	Disconnect all client and host socket connection.
	*/
	protected synchronized void disconnect() {

		if (mPool != null) {
			mPool.close();
		}

		try {
			if (mClientHttpIn != null)	mClientHttpIn.close();
			if (mClientHttpOut != null) mClientHttpOut.close();
			if (mHostHttpIn != null)	mHostHttpIn.close();
			if (mHostHttpOut != null)	mHostHttpOut.close();
		} catch (Exception e) {
		}
		
		// avoid reuse
		mClientHttpIn = null;
		mClientHttpOut = null;
		mHostHttpIn = null;
		mHostHttpOut = null;

		Util.closeSocket(mInSocket);
		Util.closeSocket(mOutSocket);

		mOriginHandler = null;
	}

	private boolean isTunnelInputBufferEmpty = true;	

	/**
	Set if tunnel buffer empty.
	@param	bufferEmpty true if tunnel buffer is empty
	*/
	protected synchronized void setTunnelInputBufferEmpty(boolean bufferEmpty) {
		this.isTunnelInputBufferEmpty = bufferEmpty;
	}

	/**
	Check if tunnel buffer empty here
	@return	true = tunnel buffer is empty
	*/
	protected synchronized boolean isTunnelInputBufferEmpty() {
		try {
			if (tunnel_in.available() > 0) {
				setTunnelInputBufferEmpty(false);
			}
		} catch (Exception e) {
		}

		return isTunnelInputBufferEmpty;
	}

	protected static ProxyHandler getOriginatingTunnelProcess (int remotePortUsing) {
		ProxyHandler temp = null;
		synchronized (tunnelProcessList) {
			for (int i=0;i<tunnelProcessList.size();i++) {
				temp = (ProxyHandler) tunnelProcessList.elementAt(i);
				if (temp.mOutSocket.getLocalPort() == remotePortUsing) {
					return temp;
				}
			}
		}
		return null;
	}	

	private void writeRequestLog(int count, HttpRequestHeader reqh, HttpBody reqBody) {
		// write request log if not a image request
		StringBuffer sb = new StringBuffer(1024);
		
		if (reqh == null || reqh.isImage() && !Global.isViewImage) {
			return;
		}

		sb.append(reqh.toString());
		if (reqBody != null) {
			sb.append(reqBody.toString());
		}
		
		if (Global.isDumpLog){
			if (reqBody != null)
				Global.dumpLog.log(Dump.REQUEST_FILE, count, reqh.toString(), reqBody.toString(),(reqh.getSecure()?"https":"http"));
			else
				Global.dumpLog.log(Dump.REQUEST_FILE, count, reqh.toString(), null, (reqh.getSecure()?"https":"http"));
		}
		else{
			Global.parosFrame.logAppend(ParosFrame.REQUEST_LOG, getLogSeparator(count));				
			Global.parosFrame.logAppend(ParosFrame.REQUEST_LOG, sb.toString() + "\r\n");		
		}

	}

	private void writeResponseLog(int count, HttpResponseHeader resh, HttpBody resBody) {

		if (resh == null || resh.isImage() && !Global.isViewImage) {
			return;
		}
		
		// write request log if not a image request
		StringBuffer sb = new StringBuffer(1024);		
		
		sb.append(resh.toString());
		if (resBody != null) {
			sb.append(resBody.toString());
		}

		if (Global.isDumpLog){
			if (resBody != null)
				Global.dumpLog.log(Dump.RESPONSE_FILE, count, resh.toString(), resBody.toString(), "unknown");
			else
				Global.dumpLog.log(Dump.RESPONSE_FILE, count, resh.toString(), null, "unknown");
		}
		else{
			Global.parosFrame.logAppend(ParosFrame.RESPONSE_LOG, getLogSeparator(count));				
			Global.parosFrame.logAppend(ParosFrame.RESPONSE_LOG, sb.toString() + "\r\n");		
		}

	}


	protected String getLogSeparator(int id) {
		return "\r\n****************** " + id + " ******************\r\n";
	}

	protected void showErrMessage(String errMsg) {
          System.out.println(errMsg);

	}

	//protected void assumeProxy() {
	//	mClientHttpInReqHeader.setAbsoluteUriRequired(true);
	//}
	
	private void modifyUserAgent(HttpRequestHeader req) {
		if (!Global.isModifyUserAgent) {
			return;
		}
		
		String userAgent = req.getHeader(HttpHeader.USER_AGENT);
		if (userAgent == null) {
			userAgent = "";
		}
		
		String delimiter = "";
		if (!userAgent.equals("") && !userAgent.endsWith(" ")) {
			delimiter = " ";
		}
		
		userAgent = userAgent + delimiter + Global.APP_NAME + "/" + Global.APP_VERSION;
		req.setHeader(HttpHeader.USER_AGENT, userAgent);
	}
	
	private void processDirectHttp11() throws Exception {

		Vector queue = new Vector();
		boolean isFirstRequest = true;
		boolean isHostCloseRequired = false;
		boolean isExit = false;
		ConnectionQueueEntry queueEntry = null;
		
		mPool	= new HttpConnectionPool(Global.config, Global.ssl);
		mClientHttpIn.setSocket(mInSocket);
		do {
						
			// read requests until no more
		
			while (isFirstRequest || mClientHttpIn.available() > 0) {
				
				if (!isFirstRequest) {
					mClientHttpInReqHeader = (HttpRequestHeader) mClientHttpIn.readHeader();
					afterRequestHeaderRead(mClientHttpInReqHeader);
				}
				isFirstRequest = false;

				mClientHttpInReqBody = mClientHttpIn.readBody();

				/* pass to Admin Server */
//				System.out.println(mHostName + ":" + mHostPort);
//				System.out.println(mClientHttpInReqHeader.getHostName() + ":" + mClientHttpInReqHeader.getHostPort()); 
				if (Global.isRunAdminServer && mClientHttpInReqHeader.getHostPort() == AdminServer.ADMIN_SERVER_PORT && mClientHttpInReqHeader.getHostName().equalsIgnoreCase("paros")){
					processAdmin();
					return;			
				}

		// process header and body with enabled filters
		Global.filterManager.filterRequest(mClientHttpInReqHeader,mClientHttpInReqBody);

				connectHost(mClientHttpInReqHeader);
				modifyHeaders(mClientHttpInReqHeader);
           		Global.treePanel.setTree(mClientHttpInReqHeader, mClientHttpInReqBody);

				mHostHttpOut.write(mClientHttpInReqHeader);
				mHostHttpOut.write(mClientHttpInReqBody);

				queueEntry = new ConnectionQueueEntry(mConn);
				queueEntry.setRequest(mClientHttpInReqHeader, mClientHttpInReqBody, counter.getNextSerial());
				//System.out.println("header written:" + queueEntry.mCount + "\r\n" + mClientHttpInReqHeader.toString());

				// write status and logs				
				processRequestLog(queueEntry);

				queue.add(queueEntry);
				count = queueEntry.mCount;
							
			}
			
			Thread.yield();
			
			if (!queue.isEmpty()) {

				queueEntry = (ConnectionQueueEntry) queue.firstElement();
				mConn = queueEntry.conn;
				
				if (mConn.mHttpIn.available() > 0) {

					mOutSocket = mConn.mSocket;
					mHostHttpIn = mConn.mHttpIn;
					
					mHostHttpInResHeader = (HttpResponseHeader) mHostHttpIn.readHeader();
					//System.out.println("mHostHttpInResHeader:" + queueEntry.mCount + "\r\n" + mHostHttpInResHeader);
					mHostHttpInResBody = mHostHttpIn.readBody();

		// process header and body with enabled filters
		Global.filterManager.filterResponse(queueEntry.mReqHeader, mHostHttpInResHeader,mHostHttpInResBody);

					processResponseLog(queueEntry);

					if (mHostHttpInResHeader.isConnectionClose()) {
						isHostCloseRequired = true;
						mConn.close();
					}
					
					mClientHttpOut.write(mHostHttpInResHeader);
					mClientHttpOut.write(mHostHttpInResBody);

					notifyWrittenToTunnel();

					if (mClientHttpInReqHeader.isConnectionClose()) {
						break;
					}

					if (mHostHttpInResHeader.getStatusCode() != HttpStatusCode.CONTINUE) {
						queue.remove(queueEntry);
					}
				}
			}

			if (queue.size() > 0 && mPool.available() > 0) {
				continue;
			}

			
			if (mClientHttpIn.available() > 0) {
				continue;
			}
			
			if (queue.size() == 0 && isHostCloseRequired) {
				break;
			}

			Util.sleep(20);
			
			if (queue.size() == 0 && mClientHttpIn.available() == 0 && timeDiffMillis() > 1000) {//	slow response when not going via proxy
				break;
			}


		} while (timeDiffMillis() < 45000 && !isTrapEnabled());

	}

	private void modifyHeaders(HttpRequestHeader req) {

		boolean useAbsoluteUri = isUseAbsoluteUri(req.getHostName());
		req.setAbsoluteUriRequired(useAbsoluteUri);
		modifyUserAgent(req);
		req.setHeader(HttpHeader.ACCEPT_ENCODING,null);
	}

	private long timeDiffMillis() {
		return (System.currentTimeMillis() - mPool.lastActiveTimeMillis());
	}
	
	private boolean isTrapEnabled() {
		boolean isEnabled = Global.trapPanel.isTrapRequest() || Global.trapPanel.isTrapResponse();
		return isEnabled;
	}
	
	private void processRequestLog(ConnectionQueueEntry entry) {
		if (entry.mReqHeader.isImage() && !Global.isViewImage) {
			return;
		}
		String statusLog = entry.mReqHeader.getPrimeHeader();
		Global.parosFrame.setStatus(statusLog);
		writeRequestLog(entry.mCount, entry.mReqHeader, entry.mReqBody);
	}
	
	private void processResponseLog(ConnectionQueueEntry entry) {
		String statusLog = null;
		
		// write status and logs
		if (entry.mReqHeader.isImage()) {
			counter.waitForTurn(entry.mCount, 1);
		} else {
			counter.waitForTurn(entry.mCount, 2000);
		}

		writeOutputLog(entry.mCount, entry.mReqHeader, mHostHttpInResHeader, System.currentTimeMillis()-entry.mTimeMillis);
		
		writeResponseLog(entry.mCount, mHostHttpInResHeader, mHostHttpInResBody);					
		counter.setTurn(entry.mCount);
	
	}
	
	private void notifyWrittenToTunnel() {
		synchronized (mOriginHandler) {
			mOriginHandler.setTunnelInputBufferEmpty(false);
			mOriginHandler.notify();
		}
	}
	
	private void writeOutputLog(int counter, HttpRequestHeader reqHeader, HttpResponseHeader resHeader, long diffTimeMillis) {

		Global.parosFrame.setStatus(" ");

		if ((reqHeader.isImage() || resHeader.isImage()) && !Global.isViewImage) {
			return;
		}

		StringBuffer sb = new StringBuffer(counter + ": " + reqHeader.getPrimeHeader() + "\t=> ");
		sb.append(resHeader.getPrimeHeader());
		String diffTimeString = " [" + decimalFormat.format((double) (diffTimeMillis/1000.0)) + " s]";
		sb.append(diffTimeString);
		//sb.append("\r\n");
		Global.parosFrame.logAppend(ParosFrame.URL_LOG,sb.toString());	
		//Global.parosFrame.logAppend(sb.toString());		
	}

}

class ConnectionQueueEntry {
	HttpConnection conn = null;
	int mCount = 0;
	HttpRequestHeader	mReqHeader = null;
	HttpBody			mReqBody = null;
	long	mTimeMillis = 0;
	
	ConnectionQueueEntry(HttpConnection conn) {
		this.conn = conn;
	}
	
	void setRequest(HttpRequestHeader req, HttpBody body, int count) {
		mReqHeader = req;
		mReqBody = body;
		mTimeMillis = System.currentTimeMillis();
		mCount = count;

	}
}


