/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.document;

import java.util.Vector;

import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;

public class WebDoc implements  java.io.Serializable {
	String name=null;
	String date=null;
	Vector history = null;
	int index=0;
	int totalWebLink = 0;

	public WebDoc(){
		history = new Vector();
		
	}

	public void clear(){
		history = null;
		history = new Vector();
		index = 0;
		totalWebLink = 0;
	}

		public String getName(){
			return name;
		}
		public String getDate(){
			return date;
		}
		public void setDate(String s){
			date = s;
		}
		public void setName(String s){
			name = s;
		}
		
		public void resetIndex(){
			index=0;		
		}
		

		public int getHistorySize(){
			return history.size();
		}
	
		public synchronized void setHistory(Object obj){
			if (history==null)	history = new Vector();
				history.addElement(obj);
				totalWebLink++;
		}
		
		public synchronized int getTotalWebLink(){
			return totalWebLink;	
		}
		public synchronized void setTotalWebLink(int c){
			totalWebLink =c;	
		}
		
		public synchronized Object getHistory(){  // should only be used by Save Cache
				if (index==history.size()) return null;
				Object obj = history.elementAt(index);				
				index++;
				return obj;
		}

		public synchronized Object getHistory(int i){  // used by here
				if (i >= history.size() || i<0) return null;
				Object obj = history.elementAt(i);								
				return obj;
		}

		public synchronized Object getHistory(String host, String url){
				WebLink w=null;
				for (int i=0; i<history.size(); i++){
					w = (WebLink)history.elementAt(i);
// 					if (w.getHost().trim().equals(host) && ((HttpRequestHeader)w.getReqHeader()).getAbsoluteURI().trim().equals(url)){					
//					System.out.println("wURL " + ((HttpRequestHeader)w.getReqHeader()).getAbsoluteURI().trim());
//					System.out.println("whost " + w.getHost().trim());
 					if (w.getHost().trim().equals(host) && w.getURL().trim().equals(url)){					
 						return w;	 					
 					}					
				}							
				return null;
		}

		public synchronized Object getHistory(String host, String url, String post){
				WebLink w=null;
				for (int i=0; i<history.size(); i++){
					w = (WebLink)history.elementAt(i);
 					if (w.getURL().trim().equals(url) 
 							&& w.getHost().trim().equals(host)
 							&& w.getReqContent().toString().equals(post)
 							){					
 						return w;	 					
 					}					
				}							
				return null;
		}


		public synchronized int getHistoryCount(String host){
				int cnt =0;
				for (int i=0; i<history.size(); i++){
					if (((WebLink)history.elementAt(i)).getHost().trim().equals(host))
 						cnt++;
				}							
				return cnt;
		}
/*
		public synchronized Object getHistoryWithHTML(int i){  // used by AdminServer
				if (i >= history.size() || i<0) return null;
				WebLink w = (WebLink)history.elementAt(i);	
				while (w.getRespContent().toString().indexOf("<HTML>")==-1){
					i++;
					if (i >= history.size() || i<0) return null;
					w = (WebLink)history.elementAt(i);
				}
																				
				return (Object)w;
		}
*/		
/*		
		public synchronized Object getHistoryWithHTML(String host, String url){  // used by AdminServer
				WebLink w=null;
				for (int i=0; i<history.size(); i++){
					w = (WebLink)history.elementAt(i);
 					if (w.getHost().trim().equals(host) && ((HttpRequestHeader)w.getReqHeader()).getAbsoluteURI().trim().equals(url) && w.getRespContent().toString().indexOf("<HTML>")!=-1){					
 						return w;	 					
 					}					
				}							
				return null;
		}
*/

	// called by AdminServer only
	public synchronized String toHTML(){
		String CRLF = "\r\n";
		String s = "";//"Website Cache Information:\r\n\r\n";
//		s += "Total links cached: " + history.size() + "\r\n\r\n";

		WebLink w=null;
		int end = history.size();
		String uri = "";
		for (int i=0; i<end; i++){
			w = (WebLink)history.elementAt(i);			
			String http_mode = w.isHttpsLink()?"https://":"http://";
			uri = http_mode + w.getHost() + ((HttpRequestHeader)w.getReqHeader()).getAbsoluteURI();

			if (w.getRespContent().toString().toLowerCase().indexOf("</html>")!=-1){  
				// only allow html pages to be clicked				
//				s += "<a href='" + uri + "' onClick=javascript:window.open('','browse',height=470,width=500,scrollbar=yes,resizable=yes);browse.location.replace('"+ uri + "')"	+ ">";
				s += "<a href='" + uri + "' target=browse>";
				s+= "["+ ((HttpResponseHeader)w.getRespHeader()).getStatusCode() + "] " + uri + CRLF;			
				s += "</a><br>";				
			}
			else{
				// for display urls of types including .gif, .cs, .js, etc
				s += "<a href='" + uri + "' target=browse><font color=#9999CC>";
				s+= "["+ ((HttpResponseHeader)w.getRespHeader()).getStatusCode() + "] " + uri + CRLF;			
				s += "</font></a><br>";				
			}

		}							
		return s;		
		
	}

	public synchronized String toString(){
		String CRLF = "\r\n";
		String s = "";//"Website Cache Information:\r\n\r\n";
//		s += "Total links cached: " + history.size() + "\r\n\r\n";

		WebLink w=null;
		for (int i=0; i<history.size(); i++){
			w = (WebLink)history.elementAt(i);
//			s+= w.getHost() + ((ReqHttpHeader)w.getReqHeader()).getAbsoluteURI() + "          " + ((HttpResponseHeader)w.getRespHeader()).getResponseCode() + " " + ((RespHttpHeader)w.getRespHeader()).getReasonPhrase() + CRLF;			
			s+= "["+ ((HttpResponseHeader)w.getRespHeader()).getStatusCode() + "] " + w.getHost() + ((HttpRequestHeader)w.getReqHeader()).getAbsoluteURI()  + CRLF;			
		}							
		return s;		
	}

}



