/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.filter;

import javax.swing.JDialog;

import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.network.HttpBody;

abstract public class AbstractFilter {
	
	protected JDialog dialog = null;
	
	public AbstractFilter() {
	}

	/**
	 * Filter request.  Default no action.
	 * 
	 * @param reqHeader
	 * @param reqBody
	 */
	public void filterRequest(HttpRequestHeader reqHeader, HttpBody reqBody) {

	}

	/**
	 * Filter response.  Default no action.
	 * @param reqHeader
	 * @param resHeader
	 * @param resBody
	 */
	public void filterResponse(HttpRequestHeader reqHeader, HttpResponseHeader resHeader, HttpBody resBody) {
		
	}
	
	/*
	 * Clear/reset the filter internal status such as local variables
	 */
	public void clearInternalStatus(){
	}
	
	abstract public String usage();
	
	/**
	 * return the configuration Dialog if any, or return NULL
	 */
	public JDialog getDialog() {
		return dialog;
	}
	
}

class PDialog extends JDialog{
	private String name = "";
	PDialog(String paramName){
		super();
		name = paramName;
	}
	
	
	public String toString(){
		return name;
	}	

	public void show(){};
}
