/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.DefaultListModel;

/**
 *
 */
public class DumpAnalyzer {
	protected DefaultListModel model = new DefaultListModel();
	protected boolean isCurSession = true;  // by default read the session_log
	protected Dump dump = null;
	protected String REQUEST_FILE = Dump.REQUEST_FILE;
	protected String RESPONSE_FILE = Dump.RESPONSE_FILE;
	protected BufferedReader requestFeed = null;
	protected BufferedReader responseFeed = null;
	//	e.g. <!--//=============== 1071556339875-1.1071556310906 ===============//-->
	protected Pattern patternHeader = Pattern.compile(Dump.SEPARATOR_LEFT
											+ "\\d+[-]((\\d+)[.](\\d+))"
											+ Dump.SEPARATOR_RIGHT);
	//	Pattern patternNum	= Pattern.compile("[*]+ (\\d+) [*]+"); //******************");
//	protected Pattern patternSpace = Pattern.compile(" ");
//	protected Pattern patternContentLen = Pattern.compile("Content-Length: (\\d+)");
	/**
	 * 
	 */
	DumpAnalyzer(Dump d) {
		dump = d;
	}

	public boolean openFile() {
		// read
		try {
			File selFile = dump.getFile(REQUEST_FILE);
			File selFile2 = dump.getFile(RESPONSE_FILE);
			if (!selFile.exists() || !selFile2.exists()) {
				return false;
			}

			requestFeed = new BufferedReader(new FileReader(selFile));
			responseFeed = new BufferedReader(new FileReader(selFile2));
			// do what you want here
			//readLines();
			return true;
		} catch (IOException ae) {
			// Error
			requestFeed = null;
			responseFeed = null;
			System.out.println("Dump files not found.");
		}
		return false;
	}

	/*	
		private void readLines(){
			String line=null;
			Matcher matcher;
			Matcher spaceMatcher;
			try {
				while ((line=requestFeed.readLine())!=null){
					if (!line.equals("")){
						matcher = patternHeader.matcher(line);
						if (matcher.find()){
							// start of a request
							System.out.println("-=-=-=- " + stringToDigit(matcher.group(1)) + " -=-=-=-");
						}
						else{
							spaceMatcher = patternSpace.matcher(line);
							if  (!spaceMatcher.find()){
								// it's request body line (by checking space on the line, not good enough, maybe change later on)
								System.out.println("");
								System.out.println(line);							
							}						
							else // normal header lines
								System.out.println(line); 
						}
							
					}
						
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				//e.printStackTrace();
				System.out.println(e.getMessage());
			}
		}
	*/
	protected long stringToDigit(String s) {
		return Long.parseLong(s);
	}

	public static void main(String[] args) {
		DumpAnalyzer da = new DumpAnalyzer(new Dump());
		da.openFile();
		//		da.readLines();

	}

	private Vector searchIndex(String selected, String type) {
		String separator = "\t";
		Matcher matcher = null;
		// pattern is "res <id> <header_line_pos> <header_start_pos> <header_end_pos> <body_end_pos>"   
		Pattern patternLine = Pattern.compile(
			type.substring(0,3)
			+ separator 
			+ selected 
			+ separator
			+ "(\\d+)"
			+ separator
			+ "(\\d+)"
			+ separator
			+ "(\\d+)"
			+ separator
			+ "(\\d+)"
			+ "(" + separator + "(\\w+)" + ")*"
			+ "\r\n");
		CharSequence cs = null;
		CharSequence cs2 = null;
		try {
			cs = fromFile(dump.getFilePath(Dump.INDEX_FILE));
		} catch (IOException e) {
			// due to the missing of index file
//			System.out.println(e.getMessage());
			return null;
		}
		matcher = patternLine.matcher(cs);
		if (matcher.find()){
			long start =Long.parseLong(matcher.group(2));
			long middle =Long.parseLong(matcher.group(3));
			long end =  Long.parseLong(matcher.group(4));
			String httpsFlag = "http";
			if (matcher.groupCount()>5 && matcher.group(6).startsWith(httpsFlag)){
				httpsFlag = matcher.group(6);
			}

			Vector result = new Vector(3);
			
			try {
				cs2 = fromFile(dump.getFilePath(type), start, end-start);
				result.add(cs2.subSequence(0,(int) (middle-start)));
				if (end-middle > 1000000)// don't display body larger than 1M bytes
					result.add("Body content too large (maybe a binary file). Cannot be displayed.");				
				else
					result.add(cs2.subSequence((int) (middle-start),(int) (end-start)).toString());
			} catch (IOException e1) {
				// due to the missing of index file
				System.out.println(e1.getMessage());
				return null;
			}
/*				int split;
			//String[] tResult = cs2.toString().split("\r\n\r\n"); 
			String tmpResult = cs2.toString();

				if ((split=tmpResult.indexOf("\r\n\r\n"))==-1){				 
//				Vector result = new Vector(2);
//				if (tResult.length <2){
					result.add(tmpResult + "\r\n");
					result.add("");
				}
				else{
					result.add(tmpResult.substring(0,split) + "\r\n");
					if (tmpResult.substring(split+4).length() > 1000000)  // don't display body larger than 1M bytes
						result.add("Body content too large (maybe a binary file). Cannot be displayed.");
					else
						result.add(tmpResult.substring(split+4));
				}
*/
			cs = null;
			cs2 = null;
			result.add(httpsFlag);			
			return result;
		}

//		System.out.println(type + " search failed with id " + selected);
		return null;				
	}
	/**
	 * @param selected	selected ID in format ddd.ddddddd
	 * @return
	 */
	public Vector searchRequest(String selected) {
		if (selected.indexOf(".")==-1)
			selected = selected + "." + dump.getCurDate();

		Vector qresult;
		qresult = searchIndex(selected, REQUEST_FILE);
		if (qresult!=null)
			return qresult;

		// search failed, probably due to missing index file, so continue here 
		String line = "";	
		Pattern patternLine = Pattern.compile(
			Dump.SEPARATOR_LEFT
			+ "\\d+[-]" 
			+ selected 
			+ Dump.SEPARATOR_RIGHT);

		Matcher matcher = null;
		Matcher matcher2 = null;
		CharSequence cs = null;
		try {
			cs = fromFile(dump.getFilePath(Dump.REQUEST_FILE));
			matcher = patternLine.matcher(cs);
		} catch (IOException e1) {
			// due to the missing of index file
			System.out.println(e1.getMessage());
			return null;
		} //patternHeader.matcher(line);
		if (matcher.find()){
			// located the right response
			int startRes = matcher.end();
			int endRes ;
			
			matcher2 = patternHeader.matcher(cs);
			if (matcher2.find(startRes)){
				endRes = matcher2.start();
			}
			else{
				endRes = cs.length();
			}
			
				String request = cs.subSequence(startRes+2, endRes).toString(); // the '2' here is to skip "\r\n"
				String[] tResult = request.split("\r\n\r\n"); 
				Vector result = new Vector(2);
				if (tResult.length <2){
					result.add(tResult[0] + "\r\n");
					result.add("");
				}
				else{
					result.add(tResult[0] + "\r\n");
					result.add(tResult[1]);
				}
				cs = null;
				return result;				
		}
		// failed to find the selected ID		
		return null;

	}

	/**
	 * @param id
	 * @return
	 */
	public String searchRequestFirstLine(String selected) {
		Vector result = searchRequest(selected);
		if (result!=null){
			String header = result.get(0).toString();
			return header.substring(0,header.indexOf("\r\n"));
		}
		return null;
	}

	public String searchRequestPattern(String id, String pattern, int groupID) {
		Vector result = searchRequest(id);
		if (result!=null){
			Pattern p = Pattern.compile(pattern);
			Matcher matcher = p.matcher(result.get(0).toString());
			if (matcher.find())
			return matcher.group(groupID);
		}
		return null;
	}	

	/*
	 *  This function search the first string matched the pattern 
	 */
	private String searchContentPattern(String content, String pattern, int groupID) {
		if (content!=null){
			Pattern p = Pattern.compile(pattern);
			Matcher matcher = p.matcher(content);
			if (matcher.find())
			return matcher.group(groupID);
		}
		return null;
	}	

	/*
	 * This function search all strings matched the pattern
	 */
	private Vector searchAllContentPattern(String content, String pattern, int groupID) {
		if (content!=null){
			Vector result = new Vector(); 
			Pattern p = Pattern.compile(pattern);
			Matcher matcher = p.matcher(content);
			while (matcher.find() && result.indexOf(matcher.group(groupID))==-1){
				result.add(matcher.group(groupID));
			}
			return result;
		}
		return null;
	}	

	public Vector searchResponse(String selected) {
		if (selected.indexOf(".")==-1)
			selected = selected + "." + dump.getCurDate();

		Vector qresult = searchIndex(selected, RESPONSE_FILE);
		if (qresult!=null)
			return qresult;

		/*
		 * Search index failed, maybe due to missing index file or even response file
		 * 
		 * Try to continue and search the response file without index
		 *  
		 */ 
		
		String line = "";
		
		Pattern patternLine = Pattern.compile(
			Dump.SEPARATOR_LEFT
			+ "\\d+[-]" 
			+ selected 
			+ Dump.SEPARATOR_RIGHT);

		Matcher matcher = null;
		Matcher matcher2 = null;
		CharSequence cs = null;
		try {
			cs = fromFile(dump.getFilePath(Dump.RESPONSE_FILE));
			matcher = patternLine.matcher(cs);
		} catch (IOException e1) {
			// due to the missing of index file
			System.out.println(e1.getMessage());
			return null;
		} //patternHeader.matcher(line);
		if (matcher.find()){
//			String match =(String) (matcher.group(1));
//			if (!match.equals(selected)){
//				continue;
//			}
			// located the right response
			int startRes = matcher.end();
			int endRes ;
			
			matcher2 = patternHeader.matcher(cs);
			if (matcher2.find(startRes)){
				endRes = matcher2.start();
			}
			else{
				endRes = cs.length();
			}
//			System.out.println("start " + startRes + ":" + endRes);
				String response = cs.subSequence(startRes+2, endRes).toString(); // the '2' here is to skip "\r\n"
				int split;
				Vector result = new Vector(2);
				if ((split=response.indexOf("\r\n\r\n"))==-1){				 
//				Vector result = new Vector(2);
//				if (tResult.length <2){
					result.add(response + "\r\n");
					result.add("");
				}
				else{
					result.add(response.substring(0,split) + "\r\n");
					if (response.substring(split+4).length() > 1000000)  // don't display body larger than 1M bytes
						result.add("Body content too large (maybe a binary file). Cannot be displayed.");
					else
						result.add(response.substring(split+4));
				}
				cs = null;
				return result;				
		}

		// failed to find the selected ID		
		return null;

	}


	public CharSequence fromFile(String filename) throws IOException {
		FileInputStream fis = new FileInputStream(filename);
		FileChannel fc = fis.getChannel();

		// Create a read-only CharBuffer on the file
		MappedByteBuffer bbuf =
			fc.map(FileChannel.MapMode.READ_ONLY, 0, (int) fc.size());
		CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
		return cbuf;
	}

	public CharSequence fromFile(String filename, long start, long size) throws IOException {
		FileInputStream fis = new FileInputStream(filename);
		FileChannel fc = fis.getChannel();

		// Create a read-only CharBuffer on the file
		MappedByteBuffer bbuf =
			fc.map(FileChannel.MapMode.READ_ONLY, start, size);
		CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
		return cbuf;
	}

	/*
	 *  Obsolete function !!!
	 */
	protected void readList(Pattern pattern, String searchPlace) {
		String line = "";
		Matcher matcher = null;
		Matcher matcher3  = null;
		CharSequence cs = null, cs2 = null;
		Pattern patternHeaderLine = null;
		String fromFile;
		String curDateTime = Long.toString(dump.getCurDate());

		if (isCurSession)
		//e.g. res	100.1074601486421	490026	490104	490251	490251			
			patternHeaderLine = Pattern.compile(searchPlace.substring(0,3) + "\\t((\\d+)[.](" + curDateTime + "))\\t\\d+\\t(\\d+)\\t\\d+\\t(\\d+)");
		else
			patternHeaderLine = Pattern.compile(searchPlace.substring(0,3) + "\\t((\\d+)[.](\\d+))\\t\\d+\\t(\\d+)\\t\\d+\\t(\\d+)");
		
		model.clear();
				
		if (searchPlace.equals("request")){
			fromFile = Dump.REQUEST_FILE;
		}
		else
			fromFile = Dump.RESPONSE_FILE;
		try {
			cs = fromFile(dump.getFilePath(Dump.INDEX_FILE));
			matcher = patternHeaderLine.matcher(cs);
			cs2 = fromFile(dump.getFilePath(fromFile));
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} //patternHeader.matcher(line);
		
		String id = null;
		String website  = null;//"website info missing";
		String firstLine = null;//"URL info missing";
		Matcher matcher4 = null;
		String index = null; //  
		int index2, index3;//, index3=null;
		Pattern p1 = null;

		while (matcher.find()) {
			id=matcher.group(1);
			index = matcher.group(2);

			// if search response with blank, directly get the list to improve performance
			if (!searchPlace.equals("request") && pattern.pattern().equals("")){
				firstLine = null;
				website  = null;
//				firstLine = searchRequestFirstLine(id);
//				website = searchRequestPattern(id, "Host: (.*)\r\n", 1);				
				Vector v = searchRequest(id);
				if (v!=null){
					firstLine = v.get(0).toString();
					website = searchContentPattern(firstLine, "Host: (.*)\r\n", 1);
					int t =-1;
					if ((t = firstLine.indexOf("\r\n"))!=-1)
						firstLine  = firstLine.substring(0,t);						
				}				
				if (firstLine!=null && website!=null){
					if (isCurSession)
						model.addElement(index + "---" + website + "---" +firstLine);
					else
						model.addElement(id + "---" + website + "---" +firstLine);								
				}
				continue;
			}

			// get the list from content and request
			index2 = Integer.parseInt(matcher.group(4));
			index3 = Integer.parseInt(matcher.group(5));
			String content = cs2.subSequence(index2, index3).toString();// the '2' here is to skip "\r\n"
			matcher3 = pattern.matcher(content);
			if (matcher3.find()){
				firstLine = null;
				website  = null;
				if (searchPlace.equals("request")){
					firstLine = content.substring(0,content.indexOf("\r\n"));
					p1 = Pattern.compile("Host: (.*)\r\n");
					matcher4 = p1.matcher(content);
					if (matcher4.find())
						website = matcher4.group(1);
				}
				else{
//					firstLine = searchRequestFirstLine(id);
//					website = searchRequestPattern(id, "Host: (.*)\r\n", 1);
					Vector v = searchRequest(id);
					if (v!=null){
						firstLine = v.get(0).toString();
						website = searchContentPattern(firstLine, "Host: (.*)\r\n", 1);
						int t =-1;
						if ((t = firstLine.indexOf("\r\n"))!=-1)
							firstLine  = firstLine.substring(0,t);						
					}
//					else
//						continue;
				}
				
				if (firstLine!=null && website!=null){
					if (isCurSession)
						model.addElement(index + "---" + website + "---" +firstLine);
					else
						model.addElement(id + "---" + website + "---" +firstLine);								
				}
				
			}
		}
	}

	protected Vector listPattern(Pattern pattern, String searchPlace) {
		String line = "";
		Matcher matcher = null;
		Matcher matcher3  = null;
		CharSequence cs = null, cs2 = null;
		Pattern patternHeaderLine = null;
		String fromFile;
		String curDateTime = Long.toString(dump.getCurDate());

		if (pattern.pattern().equals("")){
			return null;
		}

		Vector result = new Vector();

		if (isCurSession)
		//e.g. res	100.1074601486421	490026	490104	490251	490251			
			patternHeaderLine = Pattern.compile(searchPlace.substring(0,3) + "\\t((\\d+)[.](" + curDateTime + "))\\t\\d+\\t(\\d+)\\t\\d+\\t(\\d+)");
		else
			patternHeaderLine = Pattern.compile(searchPlace.substring(0,3) + "\\t((\\d+)[.](\\d+))\\t\\d+\\t(\\d+)\\t\\d+\\t(\\d+)");
		
				
		if (searchPlace.equals("request")){
			fromFile = Dump.REQUEST_FILE;
		}
		else
			fromFile = Dump.RESPONSE_FILE;
		try {
			cs = fromFile(dump.getFilePath(Dump.INDEX_FILE));
			matcher = patternHeaderLine.matcher(cs);
			cs2 = fromFile(dump.getFilePath(fromFile));
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} //patternHeader.matcher(line);
		
		String id = null;
		Matcher matcher4 = null;
		String index = null; //  
		int index2, index3;//, index3=null;
		Pattern p1 = null;

		// first - search id 
		while (matcher.find() ) {
			id=matcher.group(1);
			index = matcher.group(2);

			index2 = Integer.parseInt(matcher.group(4));
			index3 = Integer.parseInt(matcher.group(5));
			String content = cs2.subSequence(index2, index3).toString();// the '2' here is to skip "\r\n"
				
			// second - search the pattern
			Vector tmpRes = searchAllContentPattern(content, pattern.pattern(), 0);
			if (tmpRes!=null){
				for (int q=0;q< tmpRes.size();q++){
					if (result.indexOf(tmpRes.get(q))==-1)
						result.add(tmpRes.get(q));
				}
			}
		}
		if (result.size()<1)
			result = null;
			
		return result;
	}

	protected Vector listPatternOld(Pattern pattern, String searchPlace, boolean isStop) {
		String line = "";
		Matcher matcher = null;
		Matcher matcher3  = null;
		CharSequence cs = null, cs2 = null;
		Pattern patternHeaderLine = null;
		String fromFile;
		String curDateTime = Long.toString(dump.getCurDate());

		if (pattern.pattern().equals("")){
			return null;
		}

		Vector result = new Vector();	
				
		if (searchPlace.equals("request")){
			fromFile = Dump.REQUEST_FILE;
		}
		else
			fromFile = Dump.RESPONSE_FILE;
		try {
			cs2 = fromFile(dump.getFilePath(fromFile));
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} //patternHeader.matcher(line);
		
		String content = cs2.toString();// the '2' here is to skip "\r\n"
				
		result = searchAllContentPattern(content, pattern.pattern(), 0);
		if (result!=null && result.size()<1)
			result = null;
			
		return result;
	}


	protected void readList2(Pattern pattern, String searchPlace) {
		String line = "";
		Matcher matcher = null;
		Matcher matcher2 = null;
		Matcher matcher3  = null;
		CharSequence cs = null;
		Pattern patternHeaderLine = null;
		String fromFile;

		if (isCurSession)
			patternHeaderLine = this.getDump().getCurrentHeaderPattern();
		else
			patternHeaderLine = this.getDump().getHeaderPattern("\\d+");		

		model.clear();
				
		if (searchPlace.equals("request")){
			fromFile = Dump.REQUEST_FILE;
		}
		else
			fromFile = Dump.RESPONSE_FILE;
		try {
			cs = fromFile(dump.getFilePath(fromFile));
			matcher = patternHeaderLine.matcher(cs);
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} //patternHeader.matcher(line);
		
		int startRes = 0;
		int endRes = 0;
		String id = null;
		String website  = null;//"website info missing";
		String firstLine = null;//"URL info missing";
		Matcher matcher4 = null;
		String index = null, index2=null;
		Pattern p1 = null;
		String curDateTime = Long.toString(dump.getCurDate());
		while (matcher.find(startRes)) {
			// located the right response
			startRes = matcher.end();
			id=matcher.group(1);
			index = matcher.group(2);
			index2 = matcher.group(3);
//			matcher2 = patternHeader.matcher(cs);
			if (matcher.find(startRes)) {
				endRes = matcher.start();
			} else {
				endRes = cs.length();
			}

			String content = cs.subSequence(startRes + 2, endRes).toString();// the '2' here is to skip "\r\n"
			matcher3 = pattern.matcher(content);
			if (matcher3.find()){
				firstLine = null;
				website  = null;
				if (searchPlace.equals("request")){
					firstLine = content.substring(0,content.indexOf("\r\n"));
					p1 = Pattern.compile("Host: (.*)\r\n");
					matcher4 = p1.matcher(content);
					if (matcher4.find())
						website = matcher4.group(1);
				}
				else{
					firstLine = searchRequestFirstLine(id);
					website = searchRequestPattern(id, "Host: (.*)\r\n", 1);				
				}
				
				if (firstLine!=null && website!=null){
					if (curDateTime.equals(index2))
						model.addElement(index + "---" + website + "---" +firstLine);
					else
						model.addElement(id + "---" + website + "---" +firstLine);								
				}
			}
		}
	}

	/**
	 * @return
	 */
	public boolean isCurSession() {
		return isCurSession;
	}

	/**
	 * @param b
	 */
	public void setCurSession(boolean b) {
		isCurSession = b;
	}

	/**
	 * @return
	 */
	public BufferedReader getRequestFeed() {
		return requestFeed;
	}

	/**
	 * @return
	 */
	public BufferedReader getResponseFeed() {
		return responseFeed;
	}

	/**
	 * @return
	 */
	public Pattern getPatternHeader() {
		return patternHeader;
	}

	/**
	 * @return
	 */
	public Dump getDump() {
		return dump;
	}

}
