/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpRequestHeader;

//import java.util.Enumeration;
//import java.util.Hashtable;
//import java.util.Vector;
//
//import com.proofsecure.paros.Global;

/**
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ScannerOneRequest extends AbstractScanner{
	/**
	 * 
	 */
//	 	protected AlertDB		mAlertDB = new AlertDB();
//	private TreeSet			mAlertList = new TreeSet();
	protected static final String CRLF = "\r\n";
	protected static java.text.DecimalFormat decFormat = new java.text.DecimalFormat("##0.###");

	protected void process(){
	}
	
	protected void endOfProcess() {
		Global.currentScanner = null;

		Global.scanner.generateAlertReport();
	}
		
	public ScannerOneRequest() throws Exception{
		super();
		// TODO Auto-generated constructor stub
		Global.currentScanner = this;
		removeAllAlert();
	}

	public void test(ParsedEntity p) {
		long startTime = 0, diffTime = 0;
//		String curDateTime = Long.toString(da.getDump().getCurDate());
	
		ParsedEntity child = ((ParsedEntity)(p.getFirstChild()));
		HttpRequestHeader header = child.getRequestHeader();
		header.setHeader(HttpHeader.IF_MODIFIED_SINCE, null);
		header.setHeader(HttpHeader.IF_NONE_MATCH, null);
		p.setHostName(header.getHostName());
		p.setHostPort(header.getHostPort());
		p.setSecure(header.getSecure());
		child.setHostName(header.getHostName());
		child.setHostPort(header.getHostPort());
		child.setSecure(header.getSecure());
		
		
		mAnalyser = new Analyser();
		mAnalyser.startTest(p);

		Global.scanner.removeAllAlert();
		startTime = System.currentTimeMillis();
		com.proofsecure.paros.util.Util.writeOutput("Scanning ...");

		Object test = null;
		Hashtable testlist = Global.scanManager.getHashtable();
		Vector enablelist = Global.scanManager.getDataModel();

		int i=0;
		for (Enumeration e = testlist.elements() ; e.hasMoreElements() && !mIsSignalStop;) {
			test = e.nextElement();
			if ( ((Boolean)(((Vector)(enablelist.elementAt(i))).elementAt(0))).booleanValue() ){
				if (test instanceof AbstractTest){
					mTestModel = (AbstractTest)test;
					writeOutput("Testing " + mTestModel.getTestName() + "...");
					try {
//						mTestModel.mReqHeader = p.getRequestHeader();
//						mTestModel.mReqBody = p.getRequestBody();
//						mTestModel.scan();
						mTestModel.startTest(p);
					} catch (Exception e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				}    	          	       
				
			}
			i++;
		}
/*	    
		if (mTestModel != null) {
			mTestModel.getThreadPool().waitAllThreadComplete(30000);
		}
		*/
		java.text.DecimalFormat decFormat =
			new java.text.DecimalFormat("##0.###");

		diffTime = System.currentTimeMillis() - startTime;
		String diffTimeString =
			decFormat.format((double) (diffTime / 1000.0)) + "s";

		com.proofsecure.paros.util.Util.writeOutput(
			"Scanning completed in " + diffTimeString);
		com.proofsecure.paros.util.Util.writeStatus("Done.");

			endOfProcess();


	}

/*	
	public static void writeOutput(String s){
		System.out.println(s);
	}
	public static void writeStatus(String s){
		System.out.println(s);
	}
*/	
	private CharSequence fromFile(String filename) throws IOException {
		FileInputStream fis = new FileInputStream(filename);
		FileChannel fc = fis.getChannel();
	
		// Create a read-only CharBuffer on the file
		MappedByteBuffer bbuf =
			fc.map(FileChannel.MapMode.READ_ONLY, 0, (int) fc.size());
		CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
		return cbuf;
	}

	
	public static void main(String[] args) {
		try{
		ScannerOneRequest s = new ScannerOneRequest();
		}
		catch(Exception e){}

	}
}
