/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.io.IOException;
import java.util.regex.Pattern;

import com.proofsecure.paros.network.HttpStatusCode;

class TestParamTamper extends TestAbstractParam {

	// should not be changed to static as Global may not be ready
	private String[] PARAM_LIST = {"", "@", "+", "%A", "%1Z", "%", "%00", "|"};
	
	private static Pattern patternErrorJava1 = Pattern.compile("javax\\.servlet\\.\\S+", PATTERN_PARAM);
	private static Pattern patternErrorJava2 = Pattern.compile("invoke.+exception|exception.+invoke", PATTERN_PARAM);

	private static Pattern patternErrorVBScript = Pattern.compile("Microsoft(\\s+|&nbsp)*VBScript(\\s+|&nbsp)+error", PATTERN_PARAM);
	private static Pattern patternErrorODBC1 = Pattern.compile("Microsoft OLE DB Provider for ODBC Drivers.*error", PATTERN_PARAM);
	private static Pattern patternErrorODBC2 = Pattern.compile("ODBC.*Drivers.*error", PATTERN_PARAM);

	TestParamTamper() {
	}

    public String toString() {
        return "TestParamTamper";
    }
    
	public String getTestName() {
		return "Parameter Tampering";
	}	
	
	protected void check(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {

		String bingoQuery = null;
		String displayURI = null;
		String newQuery = null;
		
		String resBodyNormal = null;
		
		int pos = 0;
		long defaultTimeUsed = 0;
		long timeUsed = 0;
		long lastTime = 0;
		
		// always try normal query first
		newQuery = insertQuery(query, insertPos, paramKey + "=" + paramValue);
		createMessage(isBody, newQuery);
		lastTime = System.currentTimeMillis();
		sendAndReceive();
		defaultTimeUsed = System.currentTimeMillis() - lastTime;
		if (getResponseHeader().getStatusCode() != HttpStatusCode.OK) {
			return;
		}
		resBodyNormal = getResponseBody().toString();
		
		// loop parameters
		for (int i=0; i<PARAM_LIST.length; i++) {
			if (i == 0) {
				// try without the parameter
				bingoQuery = insertQuery(query, insertPos, "");
			} else {
				bingoQuery = insertQuery(query, insertPos, paramKey + "=" + PARAM_LIST[i]);
			}
			createMessage(isBody, bingoQuery);
			lastTime = System.currentTimeMillis();
			sendAndReceive();
			defaultTimeUsed = System.currentTimeMillis() - lastTime;
			displayURI = getRequestHeader().getURIHostPathQuery();
			//System.out.println(displayURI);
			if (checkResult(bingoQuery, resBodyNormal)) {
				return;
			}
		}

		
	}

	private boolean checkResult(String query, String normalHTTPResponse) {

		StringBuffer sb = new StringBuffer();

		if (getResponseHeader().getStatusCode() != HttpStatusCode.OK
			&& !HttpStatusCode.isServerError(getResponseHeader().getStatusCode())) {
			return false;
		}
		
		// remove false positive if parameter have no effect on output
		if (getResponseBody().toString().equals(normalHTTPResponse)) {
			return false;
		}
		
		if (matchBodyPattern(patternErrorJava1, sb) && matchBodyPattern(patternErrorJava2, null)) {
			bingo(20002, AlertItem.RISK_MEDIUM, AlertItem.WARNING, "", (query == null || query.length() == 0)?"[empty]" : query, sb.toString());
			return true;
		} else if (matchBodyPattern(patternErrorVBScript, sb)
				|| matchBodyPattern(patternErrorODBC1, sb)
				|| matchBodyPattern(patternErrorODBC2, sb)) {

			bingo(20002, AlertItem.RISK_MEDIUM, AlertItem.SUSPICIOUS, "", (query == null || query.length() == 0)?"[empty]" : query, sb.toString());
			return true;
		}
		
		return false;
		
	}
	
	protected void scan() throws Exception {
		boolean skip = (getEntity().mState == ParsedEntity.DO_NOT_SCAN);
			
		writeStatus("ParameterTampering: " + (skip? "(skipped) " : "") + getRequestHeader().getURIHostPath());
		if (skip) {
			return;
		}
		init();
		checkUrlOrBody(false, myQuery);
		checkUrlOrBody(true, myReqBody.toString());
	}


}