/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

class TestURL extends AbstractServerTest {

	private URI mUri = null;
	private final static Pattern patternNotFound = Pattern.compile("(\\bNot\\sfound\\b)|(\\b404\\b)", PATTERN_PARAM);
	private int	mAlertID = 0;
	
	public TestURL(int id) {
		mAlertID = id;
	}

	public String getTestName() {
		return "URL";
	}

	protected void scan() throws Exception {
		testFile();
	}

	protected void init(String dir, String file) throws URISyntaxException {
		URI		oldUri	= getEntity().getURIHostPath();
		
		if (!dir.startsWith("/")) {
			dir = "/" + dir;
		}
		
		if (!file.startsWith("/") && !dir.endsWith("/")) {
			file = "/" + file;
		}
				
		String path = dir + file;
		mUri = new URI(oldUri.getScheme(), null, oldUri.getHost(), oldUri.getPort(), path, null, null);

	}

	/**
	Test existence of a file with the dir and path
	@param dir directory to scan
	@param	replaceSuffix true = replace the suffix for checking.  false = append the suffix.
	*/
	protected void testFile() throws URISyntaxException, IOException {

		getRequestHeader().setURI(mUri.toString());
		//System.out.println("DefaultFile: " + getRequestHeader().getURIHostPath());

		writeStatus("DefaultFile: " + getRequestHeader().getURIHostPath());
		//System.out.println("DefaultFile: " + getRequestHeader().getURIHostPath());

		sendAndReceive();


		if (!isFileExist(getEntity(), getRequestHeader(), getResponseHeader(), getResponseBody())) {
			return;
		}

		/*
		if (getResponseHeader().getStatusCode() != HttpStatusCode.OK) {
			return;
		}

		if (matchBodyPattern(patternNotFound)) {
			return;
		}
		*/

		bingo(mAlertID, AlertItem.RISK_MEDIUM, AlertItem.WARNING, mUri.toString(), "", "");
		
	}



}