/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.ui;

import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.Proxy;
import com.proofsecure.paros.SSLProxy;

public class OptionPanel extends JPanel{

  public final static String FILE_OPTION = "options.xml";
  
  private JTextArea textArea = new JTextArea();
  private JButton loadButton = new JButton();
  private JButton saveButton = new JButton();
  private JScrollPane textScrollPane = new JScrollPane();
  private JScrollPane btntScrollPane = new JScrollPane();
  private Box buttons;

  public OptionPanel(){
    super();
    init();
  }
  

  private void init(){

    this.setLayout(new BorderLayout());

//    textArea.setBackground(Color.LIGHT_GRAY);
//    textArea.setEditable(false);
    textArea.setMargin(new Insets(2, 4, 2, 4));

    buttons = Box.createHorizontalBox();


    buttons.add(loadButton, null);
    buttons.add(saveButton, null);

    this.add(textScrollPane, BorderLayout.CENTER);

    this.add(btntScrollPane, BorderLayout.SOUTH);
    btntScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
    btntScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    btntScrollPane.getViewport().add(buttons, null);
    textScrollPane.getViewport().add(textArea, null);


    loadButton.setText("Load");
    loadButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        readConfig();
      }
    });
    saveButton.setText("Save");
    saveButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        saveConfig();
      }
    });

	readConfig();
  }



/* FUNCTIONS  */
  
  

  void saveConfig() {
    // save 
    try{
    
    File selFile = new File(FILE_OPTION);
    
    if (selFile.exists()) {
      int answer = JOptionPane.showConfirmDialog(this, "File exists. Overwrite it?","Warning",JOptionPane.YES_NO_OPTION);
      if (answer != JOptionPane.YES_OPTION) {        
        // User clicked no
        return;
      }
    }
    
    BufferedWriter out = new BufferedWriter(new FileWriter(selFile));
    out.write(textArea.getText() );
    out.close();    
    JOptionPane.showMessageDialog(this, "Options saved."); 
  
    }catch(IOException ae){
      JOptionPane.showMessageDialog(this, "File write error!"); 
    }

	readConfig();    
  }



  void readConfig() {
    // load config.xml
    try{

      File selFile = new File(FILE_OPTION);

    
    if (!selFile.exists()) {
      JOptionPane.showMessageDialog(this, FILE_OPTION + " not found."); 
      return;
    }

     
    BufferedReader in = new BufferedReader(new FileReader(selFile));        
            
    // clear textarea            
    //textArea.setText("");      
    
    // append file to textarea
    String allstr="";
    String str;
    while ((str = in.readLine()) != null) {
       allstr += str + "\r\n";
    }
    
    in.close();
    textArea.setText(allstr);      

    textScrollPane.getVerticalScrollBar().setValue(textScrollPane.getVerticalScrollBar().getMinimum());
    
	Global.config.read(FILE_OPTION);

		if (Global.proxy != null) {
			Global.proxy.stopServer();
			Global.SSLProxy.stopServer();
		    Global.proxy = new Proxy(Global.config.getProxyIP(), Global.config.getProxyPort());
 		    Global.SSLProxy = new SSLProxy(Global.config.getProxyIP(), Global.config.getProxyPortSSL());
			Global.proxy.startServer();
			Global.SSLProxy.startServer();
		}
    }catch(Exception ae){
      JOptionPane.showMessageDialog(this, "Incompatible file format or file corrupted."); 
    }
    
	    
  }


}