/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.ui;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.BorderFactory;


public class WaitingDialog extends javax.swing.JDialog {
	private TaskThread task = null;

    private javax.swing.JButton btnCancel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;

    /** Creates new form MenuOptions */
    public WaitingDialog(TaskThread t, java.awt.Frame parent, boolean modal) {
        super(parent, modal);
		task = t;
        initComponents();
    }

    private void initComponents() {//GEN-BEGIN:initComponents

				getContentPane().setLayout(new java.awt.GridLayout(2,1));

//        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
                
        btnCancel = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        
        setTitle("");

        setResizable(false);
        setBackground(java.awt.Color.lightGray);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog();
            }
        });
        
        btnCancel.setText("Stop");
//        btnCancel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });
        
        jLabel1.setText("Running.");
        jLabel1.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
//        jLabel2.setText("Closing this window will stop it.");
        getContentPane().add(jLabel1);
//        getContentPane().add(jLabel2, BorderLayout.CENTER);
        getContentPane().add(btnCancel);

        pack();
    }//GEN-END:initComponents

    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
        closeDialog();
    }//GEN-LAST:event_btnCancelActionPerformed

    /** Closes the dialog */
    public void closeDialog() {//GEN-FIRST:event_closeDialog
			task.setStop();
			dispose();
    }//GEN-LAST:event_closeDialog


	public void show(Dimension parentSize){
		
		Dimension frameSize = this.getPreferredSize();
		  
		  if (parentSize == null){
			  	// get the desktop screen size
     		parentSize = Toolkit.getDefaultToolkit().getScreenSize();
	    }
	      
	    if (frameSize.height > parentSize.height) {
	      frameSize.height = parentSize.height;
	    }
	    if (frameSize.width > parentSize.width) {
	      frameSize.width = parentSize.width;
	    }
	    
	    this.setLocation((parentSize.width - frameSize.width) / 2, (parentSize.height - frameSize.height) / 2);
    	
      this.pack();
      this.show();  	
	}

}