/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.log.DumpRequestPanel;
import com.proofsecure.paros.log.DumpResponsePanel;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpConnection;
import com.proofsecure.paros.network.HttpConnectionPool;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.network.SSLConnector;
import com.proofsecure.paros.util.Config;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.SSLContext;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ManualTester
extends JFrame {
    private static final int FRAME_HEIGHT = 480;
    private static final int FRAME_WIDTH = 640;
    private static final String FRAME_NAME = "Send HTTP(S) request";
    private DumpRequestPanel dumpRequestPanel = new DumpRequestPanel(true);
    private DumpResponsePanel dumpResponsePanel = new DumpResponsePanel();
    protected URLConnection conn = null;
    protected HttpURLConnection hconn = null;
    protected HttpRequestHeader reqHeader = null;
    protected SSLContext sc;
    protected boolean mSecureFlag = false;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JPanel jPanel1;
    private JTabbedPane jTabbedPane1;
    private JLabel jLabel1;
    private JTextField jTextField1;
    private JLabel jLabel2;
    private JTextField jTextField2;

    public ManualTester() {
        this.initComponents();
    }

    private void initComponents() {
        this.setIconImage(Toolkit.getDefaultToolkit().createImage("paros_logo.gif"));
        this.setSize(new Dimension(640, 480));
        this.setTitle(FRAME_NAME);
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jButton1 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualTester.this.btnClickActionPerformed(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ManualTester.this.dispose();
            }
        });
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 0));
        this.jLabel1.setText("HTTP(S) + Domain:");
        this.jPanel1.add(this.jLabel1);
        this.jTextField1.setText("http://");
        this.jPanel1.add(this.jTextField1);
        this.jLabel2.setText("  Port:");
        this.jPanel1.add(this.jLabel2);
        this.jTextField2.setText("80");
        this.jPanel1.add(this.jTextField2);
        this.jButton1.setText("Send");
        this.jPanel1.add(this.jButton1);
        this.jTabbedPane1.addTab("Request", this.dumpRequestPanel);
        this.jTabbedPane1.addTab("Response", this.dumpResponsePanel);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.dumpRequestPanel.setMessage("GET / HTTP/1.0", "");
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public void show(Dimension parentSize) {
        Dimension frameSize = this.getPreferredSize();
        if (parentSize == null) {
            parentSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        if (frameSize.height > parentSize.height) {
            frameSize.height = parentSize.height;
        }
        if (frameSize.width > parentSize.width) {
            frameSize.width = parentSize.width;
        }
        this.setLocation((parentSize.width - frameSize.width) / 2, (parentSize.height - frameSize.height) / 2);
        this.pack();
        this.show();
    }

    public DumpRequestPanel getRequestPanel() {
        return this.dumpRequestPanel;
    }

    protected void setHeaderProperty(URLConnection conn, HttpRequestHeader req) {
        String[] reqlines = req.toString().split("\r\n");
        int index = 0;
        int i = 0;
        while (i < reqlines.length) {
            if (!(i == 0 && (reqlines[i].startsWith("GET") || reqlines[i].startsWith("HEAD") || reqlines[i].startsWith("OPTIONS") || reqlines[i].startsWith("POST") || reqlines[i].startsWith("PUT") || reqlines[i].startsWith("DELETE") || reqlines[i].startsWith("TRACE") || reqlines[i].startsWith("CONNECT")) || (index = reqlines[i].indexOf(" ")) == -1)) {
                conn.setRequestProperty(reqlines[i].substring(0, index - 1), reqlines[i].substring(index + 1));
            }
            ++i;
        }
    }

    public void setSecure(boolean s) {
        this.mSecureFlag = s;
    }

    private String getContent(BufferedInputStream in) {
        int len = 0;
        byte[] buf = new byte[1024];
        StringBuffer body = new StringBuffer();
        try {
            while (len >= 0) {
                len = in.read(buf);
                if (len <= 0) break;
                String temp = null;
                try {
                    temp = new String(buf, 0, len, "8859_1");
                }
                catch (Exception e) {
                    temp = new String(buf, 0, len);
                }
                body.append(temp);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return body.toString();
    }

    private void sendAndReceive(String url) throws IOException, URISyntaxException {
        boolean isSecure = false;
        boolean isUseClientCert = false;
        String header = this.dumpRequestPanel.getHeader();
        String body = this.dumpRequestPanel.getBody();
        URI aur = new URI(url);
        if (!aur.isAbsolute()) {
            System.out.println("Error: URL field incorrect.");
            return;
        }
        URL ur = aur.toURL();
        String proto = ur.getProtocol();
        if (!proto.equalsIgnoreCase("http") && !proto.equalsIgnoreCase("https")) {
            return;
        }
        if (proto.equalsIgnoreCase("https")) {
            this.setSecure(true);
            isSecure = true;
        }
        SSLConnector ssl = Global.ssl;
        Config config = Global.config;
        HttpRequestHeader reqHeader = null;
        HttpBody reqBody = null;
        HttpResponseHeader resHeader = null;
        HttpBody resBody = null;
        HttpConnectionPool pool = new HttpConnectionPool(config, ssl);
        HttpConnection hconn = null;
        boolean absoluteUriRequired = false;
        reqHeader = new HttpRequestHeader(header);
        reqBody = new HttpBody(body);
        String hostName = aur.getHost();
        int port = Integer.parseInt(this.jTextField2.getText());
        if (port == -1) {
            port = isSecure ? 443 : 80;
        }
        hconn = pool.connect(hostName, port, isSecure, isUseClientCert);
        if (!isSecure && config.useProxy(hostName)) {
            absoluteUriRequired = true;
        }
        reqHeader.setAbsoluteUriRequired(absoluteUriRequired);
        reqHeader.setContentLength(reqBody.length());
        hconn.mHttpOut.write(reqHeader);
        hconn.mHttpOut.write(reqBody);
        resHeader = (HttpResponseHeader)hconn.mHttpIn.readHeader();
        resBody = hconn.mHttpIn.readBody();
        this.dumpResponsePanel.setMessage(resHeader.toString(), resBody.toString());
        pool.close();
    }

    private void btnClickActionPerformed(ActionEvent evt) {
        this.dumpResponsePanel.setMessage("", "");
        this.jTabbedPane1.setSelectedIndex(this.jTabbedPane1.indexOfTab("Response"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ManualTester.this.sendAndReceive(ManualTester.this.jTextField1.getText());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setProxy(String proxyhost, String proxyport) {
        System.getProperties().setProperty("https.proxyHost", proxyhost);
        System.getProperties().setProperty("https.proxyPort", proxyport);
        System.getProperties().setProperty("http.proxyHost", proxyhost);
        System.getProperties().setProperty("http.proxyPort", proxyport);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ManualTester tester = new ManualTester();
        tester.setProxy("localhost", "8080");
        tester.getRequestPanel().setMessage("GET / HTTP/1.0", "");
        tester.show();
    }

    public void initValue(String header, String body, boolean httpsFlag, String domain, int port) {
        this.dumpRequestPanel.setMessage(header, body);
        this.jTextField1.setText(domain);
        this.jTextField2.setText("" + port);
        this.setSecure(httpsFlag);
    }
}

