/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.ProxyHandler;
import com.proofsecure.paros.network.HttpConnectionPool;
import com.proofsecure.paros.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;

class ProxyPortForwardHandler
extends ProxyHandler {
    ProxyPortForwardHandler() {
    }

    protected void process() {
        this.processForward(Global.cmdHostName, Global.cmdHostPort);
    }

    private void processForward(String hostName, int hostPort) {
        int len = 0;
        byte[] buf = new byte[4096];
        long lastTime = 0L;
        BufferedInputStream proxy_in = null;
        BufferedOutputStream proxy_out = null;
        BufferedOutputStream passthru_out = null;
        BufferedInputStream passthru_in = null;
        HttpConnectionPool pool = new HttpConnectionPool(Global.config, Global.ssl);
        Object conn = null;
        boolean isRespondedOnce = false;
        try {
            proxy_in = new BufferedInputStream(this.mInSocket.getInputStream(), 4096);
            proxy_out = new BufferedOutputStream(this.mInSocket.getOutputStream());
            this.mOutSocket = Util.connect(hostName, hostPort, false);
            passthru_out = new BufferedOutputStream(this.mOutSocket.getOutputStream());
            passthru_in = new BufferedInputStream(this.mOutSocket.getInputStream(), 4096);
            do {
                int i = 0;
                while (i < 3 && proxy_in.available() > 0) {
                    len = proxy_in.read(buf);
                    if (len > 0) {
                        passthru_out.write(buf, 0, len);
                        passthru_out.flush();
                        lastTime = System.currentTimeMillis();
                    }
                    ++i;
                }
                Thread.yield();
                i = 0;
                while (i < 3 && passthru_in.available() > 0) {
                    len = passthru_in.read(buf);
                    if (len > 0) {
                        proxy_out.write(buf, 0, len);
                        proxy_out.flush();
                        isRespondedOnce = true;
                        System.out.print(".");
                        lastTime = System.currentTimeMillis();
                    }
                    ++i;
                }
                if (proxy_in.available() > 0 || passthru_in.available() > 0) continue;
                Util.sleep(20);
                if (!isRespondedOnce ? System.currentTimeMillis() > lastTime + 30000L : System.currentTimeMillis() > lastTime + 4000L) break;
            } while (!this.mInSocket.isClosed() && !this.mOutSocket.isClosed() && !this.mOutSocket.isInputShutdown() && !this.mInSocket.isInputShutdown());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Util.closeInputStream(proxy_in);
        Util.closeOutputStream(proxy_out);
        Util.closeInputStream(passthru_in);
        Util.closeOutputStream(passthru_out);
        pool.close();
    }
}

