/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros;

import java.util.Hashtable;
import java.util.Random;

class Session {
    private static Hashtable table = new Hashtable();
    private static Random staticRandomGenerator = new Random();
    public static int EXISTED = 1;
    public static int NOT_EXISTED = 0;
    public static int EXPIRED = -1;

    Session() {
    }

    public String createSession() {
        String s = String.valueOf(Long.toString(Math.abs(staticRandomGenerator.nextLong()))) + Long.toString(Math.abs(staticRandomGenerator.nextLong()));
        SessionObject obj = new SessionObject();
        obj.lastTime = new Long(System.currentTimeMillis());
        table.put(s, obj);
        return s;
    }

    public int getStatus(String s) {
        if (s == null || s.equals("")) {
            return NOT_EXISTED;
        }
        SessionObject obj = (SessionObject)table.get(s);
        if (obj == null) {
            return NOT_EXISTED;
        }
        Long n = obj.lastTime;
        if (n != null && System.currentTimeMillis() - n > 1200000L) {
            this.removeSession(s);
            return EXPIRED;
        }
        if (n != null) {
            return EXISTED;
        }
        return NOT_EXISTED;
    }

    public void updateSession(String s, String lastVisitedSite) {
        if (s != null && this.getStatus(s) == EXISTED) {
            SessionObject obj = new SessionObject();
            obj.lastTime = new Long(System.currentTimeMillis());
            obj.lastSite = lastVisitedSite;
            table.put(s, obj);
        }
    }

    public String getLastSite(String s) {
        SessionObject obj = (SessionObject)table.get(s);
        if (obj != null) {
            return obj.lastSite;
        }
        return null;
    }

    public void removeSession(String s) {
        table.remove(s);
    }

    class SessionObject {
        private Long lastTime = null;
        private String lastSite = null;

        SessionObject() {
        }
    }
}

