/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.regex.Pattern;

public class Dump {
    public static String REQUEST_FILE = "request.log";
    public static String RESPONSE_FILE = "response.log";
    public static String INDEX_FILE = "index.txt";
    private long curDate = System.currentTimeMillis();
    public static String PROJECT_DIR = "project";
    private String dumpPrefix = "session";
    public static String SEPARATOR_LEFT = "<!--//=============== ";
    public static String SEPARATOR_RIGHT = " ===============//-->";

    public Dump() {
        this.checkFileSize();
    }

    public Dump(String name, boolean renameLargeFile, boolean overwrite) {
        this.dumpPrefix = name;
        if (renameLargeFile) {
            this.checkFileSize();
        }
        if (overwrite) {
            this.deleteOldFile();
        }
    }

    private void deleteOldFile() {
        File reqFile = this.getFile(REQUEST_FILE);
        File resFile = this.getFile(RESPONSE_FILE);
        File idxFile = this.getFile(INDEX_FILE);
        idxFile.delete();
        reqFile.delete();
        resFile.delete();
    }

    private void checkFileSize() {
        File reqFile = this.getFile(REQUEST_FILE);
        File resFile = this.getFile(RESPONSE_FILE);
        File idxFile = this.getFile(INDEX_FILE);
        long length = reqFile.length();
        long length2 = resFile.length();
        if (length > 6000000L || length2 > 6000000L) {
            String curDir = String.valueOf(System.getProperty("user.dir")) + File.separator + PROJECT_DIR;
            long curTime = System.currentTimeMillis();
            String path = String.valueOf(curDir) + File.separator + this.dumpPrefix + "_" + curTime + "_";
            String curFile = String.valueOf(path) + REQUEST_FILE;
            File rFile = new File(curFile);
            boolean success = reqFile.renameTo(rFile);
            if (!success) {
                System.out.println("Can't rename old dump files.");
                return;
            }
            curFile = String.valueOf(path) + RESPONSE_FILE;
            rFile = new File(curFile);
            success = resFile.renameTo(rFile);
            if (!success) {
                System.out.println("Can't rename old dump files.");
                return;
            }
            curFile = String.valueOf(path) + INDEX_FILE;
            rFile = new File(curFile);
            success = idxFile.renameTo(rFile);
            if (!success) {
                System.out.println("Can't rename old dump files.");
                return;
            }
            System.out.println("Renamed old dump files.");
        }
    }

    private String getCurDir() {
        return String.valueOf(System.getProperty("user.dir")) + File.separator + PROJECT_DIR;
    }

    public File getFile(String s) {
        String curDir = String.valueOf(System.getProperty("user.dir")) + File.separator + PROJECT_DIR;
        String curFile = String.valueOf(curDir) + File.separator + this.dumpPrefix + "_" + s;
        File dir = new File(curDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        File f = new File(curFile);
        return f;
    }

    public String getFilePath(String s) {
        File f = this.getFile(s);
        return f.getPath();
    }

    public synchronized void log(String logName, long id, String req, String res, String httpsFlag) {
        File logFile = this.getFile(logName);
        String separator = "\t";
        String index = String.valueOf(logName.substring(0, 3)) + separator + id + "." + this.curDate;
        try {
            FileChannel out = new FileOutputStream(logFile, true).getChannel();
            if (id > -1L) {
                index = String.valueOf(index) + separator + out.size();
                out.write(ByteBuffer.wrap(this.getHeaderLine(id)));
                index = String.valueOf(index) + separator + out.position();
                out.write(ByteBuffer.wrap(req.getBytes("8859_1")));
                index = String.valueOf(index) + separator + out.position();
                if (res != null) {
                    out.write(ByteBuffer.wrap(res.getBytes("8859_1")));
                }
                index = String.valueOf(index) + separator + out.position();
                if (httpsFlag != null) {
                    index = String.valueOf(index) + separator + httpsFlag;
                }
            }
            out.close();
            index = String.valueOf(index) + "\r\n";
            out = new FileOutputStream(this.getFile(INDEX_FILE), true).getChannel();
            out.write(ByteBuffer.wrap(index.getBytes()));
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error writing log: " + e.getMessage());
        }
    }

    private byte[] getHeaderLine(long id) {
        return ("\r\n" + SEPARATOR_LEFT + System.currentTimeMillis() + "-" + id + "." + this.curDate + SEPARATOR_RIGHT + "\r\n").getBytes();
    }

    public Pattern getCurrentHeaderPattern() {
        return Pattern.compile(String.valueOf(SEPARATOR_LEFT) + "\\d+[-]((\\d+)[.]" + "(" + this.curDate + ")" + ")" + SEPARATOR_RIGHT);
    }

    public Pattern getHeaderPattern(String timestamp) {
        return Pattern.compile(String.valueOf(SEPARATOR_LEFT) + "\\d+[-]((\\d+)[.]" + "(" + timestamp + ")" + ")" + SEPARATOR_RIGHT);
    }

    public String getDumpPrefix() {
        return this.dumpPrefix;
    }

    public String getPROJECT_DIR() {
        return PROJECT_DIR;
    }

    public void setPROJECT_DIR(String string) {
        PROJECT_DIR = string;
    }

    public long getCurDate() {
        return this.curDate;
    }

    public void resetCurDate() {
        this.curDate = System.currentTimeMillis();
    }

    public void setDumpPrefix(String string) {
        this.dumpPrefix = string;
    }
}

