/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.log;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.log.Dump;
import com.proofsecure.paros.log.DumpAnalyzerGUI;
import com.proofsecure.paros.log.DumpResponsePanel;
import com.proofsecure.paros.log.FilterDialog;
import com.proofsecure.paros.log.GrepDialog;
import com.proofsecure.paros.log.OpenFileDialog;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.ScannerOffline;
import com.proofsecure.paros.ui.FindDialog;
import com.proofsecure.paros.ui.TreePanel;
import com.proofsecure.paros.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class DumpFrame
extends JFrame
implements ListSelectionListener {
    private static final int FRAME_HEIGHT = 480;
    private static final int FRAME_WIDTH = 640;
    public static final String FRAME_NAME = "Log Analyzer";
    private JPanel jPanel1;
    private JPanel jTopPanel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jTopScrollPane;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTree jTree1;
    private JList jList1 = new JList();
    private TreePanel treePanel = new TreePanel();
    private DumpAnalyzerGUI da;
    private DumpResponsePanel dumpRequestPanel = new DumpResponsePanel();
    private DumpResponsePanel dumpResponsePanel = new DumpResponsePanel();
    private JTextArea commentPanel = new JTextArea();
    private JTextArea scriptPanel = new JTextArea();
    private GrepDialog grepDialog = null;
    private Box box1 = Box.createHorizontalBox();
    private JButton btnRefresh = new JButton();
    private JButton btnClear = new JButton();
    private JButton btnScan = new JButton();
    private JButton btnFilterReq = new JButton();
    private JButton btnFilterResp = new JButton();
    private JButton btnGrep = new JButton();
    private JMenuBar jMenuBar = new JMenuBar();
    private JMenu jMenuFile = new JMenu();
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JMenu jMenuEdit = new JMenu();
    private JMenuItem jMenuEditFind = new JMenuItem();
    private Pattern slashPattern = Pattern.compile("^(.*?[;]+| *)//.*$", 8);
    private Pattern slashStarPattern = Pattern.compile("/[*].*?[*]/", 40);
    private Pattern scriptPattern = Pattern.compile("<script[^>]*>(.*?)</script>", 42);
    private Pattern commentPattern = Pattern.compile("<!--.*?-->", 40);
    private String COMMENT_BREAK = "\r\n=========================================================================\r\n";

    public DumpFrame(DumpAnalyzerGUI d, DefaultListModel m) {
        this.da = d;
        this.setListModel(m);
        this.initComponents();
    }

    public void setRequest(Vector r) {
        this.dumpRequestPanel.setMessage(r.get(0).toString(), r.get(1).toString());
    }

    public void setResponse(Vector r) {
        this.dumpResponsePanel.setMessage(r.get(0).toString(), r.get(1).toString());
    }

    public void setComment(String body) {
        String m;
        if (body == null) {
            this.commentPanel.setText("");
            this.scriptPanel.setText("");
            return;
        }
        String comment = "";
        Matcher matcher = this.scriptPattern.matcher(body);
        String scripts = "";
        while (matcher.find()) {
            scripts = String.valueOf(scripts) + matcher.group(0) + this.COMMENT_BREAK;
        }
        matcher = this.commentPattern.matcher(body);
        while (matcher.find()) {
            m = matcher.group(0);
            if (scripts.indexOf(m) != -1) continue;
            comment = String.valueOf(comment) + m + this.COMMENT_BREAK;
        }
        matcher = this.slashPattern.matcher(body);
        while (matcher.find()) {
            m = matcher.group(0);
            if (scripts.indexOf(m) != -1) continue;
            comment = String.valueOf(comment) + m + this.COMMENT_BREAK;
        }
        matcher = this.slashStarPattern.matcher(body);
        while (matcher.find()) {
            m = matcher.group(0);
            if (scripts.indexOf(m) != -1) continue;
            comment = String.valueOf(comment) + m + this.COMMENT_BREAK;
        }
        if (comment != null && !comment.equals("")) {
            this.commentPanel.setText(comment);
        } else {
            this.commentPanel.setText("");
        }
        if (scripts != null && !scripts.equals("")) {
            this.scriptPanel.setText(scripts);
        } else {
            this.scriptPanel.setText("");
        }
    }

    public void showGUI() {
        this.initDisplay();
        if (!this.da.isCurSession()) {
            this.btnClear.setVisible(false);
        }
        if (Global.isST) {
            this.btnGrep.setVisible(true);
        } else {
            this.btnGrep.setVisible(false);
        }
        this.setVisible(true);
        this.show();
    }

    private void initDisplay() {
        boolean packFrame = false;
        this.initMenu();
        if (packFrame) {
            this.pack();
        } else {
            this.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2 + 20, (screenSize.height - frameSize.height) / 2 + 20);
    }

    private void initComponents() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setIconImage(Toolkit.getDefaultToolkit().createImage("paros_logo.gif"));
        this.setSize(new Dimension(640, 480));
        this.setTitle(FRAME_NAME);
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jSplitPane1.setDividerSize(3);
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jScrollPane3 = new JScrollPane();
        this.jScrollPane4 = new JScrollPane();
        this.jScrollPane5 = new JScrollPane();
        this.jTopPanel = new JPanel();
        this.jTopPanel.setPreferredSize(new Dimension(400, 160));
        this.jTopScrollPane = new JScrollPane();
        this.commentPanel.setBackground(SystemColor.activeCaptionBorder);
        this.scriptPanel.setBackground(SystemColor.activeCaptionBorder);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DumpFrame.this.exitForm(evt);
            }
        });
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DumpFrame.this.jList1.setEnabled(false);
                DumpFrame.this.da.refresh();
                DumpFrame.this.jList1.setEnabled(true);
            }
        });
        this.btnClear.setText("Clear");
        this.btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(null, "Clear the list?\r\n(this only affects the list display. Messages are still in session file)", "Warning", 0);
                if (answer != 0) {
                    return;
                }
                DumpFrame.this.jList1.setEnabled(false);
                DumpFrame.this.da.getDump().resetCurDate();
                DumpFrame.this.da.refresh();
                Global.urlLog.clear();
                DumpFrame.this.jList1.setEnabled(true);
            }
        });
        this.btnScan.setText("Offline Scan");
        this.btnScan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(null, "This function will only perform the check \"TestCacheAndMisc\" on the log, i.e. no real scan checks sent to the server.\r\nThe result may not be accurate due to reasons such as 304 response (instead of 200 OK) being saved in the file.\r\nContinue?", "Information", 0);
                if (answer != 0) {
                    return;
                }
                ScanThread thread = new ScanThread();
                thread.start();
            }
        });
        this.btnFilterReq.setText("Filter Requests");
        this.btnFilterReq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DumpFrame.this.btnFilterActionPerformed(e, "request");
            }
        });
        this.btnFilterResp.setText("Filter Responses");
        this.btnFilterResp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DumpFrame.this.btnFilterActionPerformed(e, "response");
            }
        });
        this.btnGrep.setText("Extract");
        this.btnGrep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DumpFrame.this.grepDialog == null) {
                    DumpFrame.this.grepDialog = new GrepDialog(null, true, DumpFrame.this.da);
                }
                DumpFrame.this.grepDialog.show();
            }
        });
        this.box1.add((Component)this.btnRefresh, null);
        this.box1.add((Component)this.btnClear, null);
        this.box1.add((Component)this.btnFilterReq, null);
        this.box1.add((Component)this.btnFilterResp, null);
        this.box1.add((Component)this.btnScan, null);
        this.box1.add((Component)this.btnGrep, null);
        this.jScrollPane3.setVerticalScrollBarPolicy(21);
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.getViewport().add((Component)this.box1, null);
        this.jSplitPane1.setDividerLocation(0);
        this.jList1.setFont(new Font("Dialog", 0, 10));
        this.jTopScrollPane.setViewportView(this.jList1);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.jTopPanel.setLayout(new BorderLayout());
        this.jTopPanel.add((Component)this.jTopScrollPane, "Center");
        this.jTabbedPane1.addTab("Request", this.dumpRequestPanel);
        this.jTabbedPane1.addTab("Response", this.dumpResponsePanel);
        this.jTabbedPane1.addTab("Comment", this.jScrollPane4);
        this.jTabbedPane1.addTab("Script", this.jScrollPane5);
        this.jScrollPane4.setViewportView(this.commentPanel);
        this.jScrollPane5.setViewportView(this.scriptPanel);
        this.jTabbedPane1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (DumpFrame.this.jList1.getSelectedValue() == null) {
                    return;
                }
                String selected = (String)DumpFrame.this.jList1.getSelectedValue();
                selected = selected.substring(0, selected.indexOf("---"));
                Vector result = null;
                if (DumpFrame.this.jTabbedPane1.getSelectedIndex() == DumpFrame.this.jTabbedPane1.indexOfTab("Request")) {
                    result = DumpFrame.this.da.searchRequest(selected);
                    if (result != null) {
                        DumpFrame.this.setRequest(result);
                    }
                } else if (DumpFrame.this.jTabbedPane1.getSelectedIndex() == DumpFrame.this.jTabbedPane1.indexOfTab("Response")) {
                    result = DumpFrame.this.da.searchResponse(selected);
                    if (result != null) {
                        DumpFrame.this.setResponse(result);
                    } else {
                        result = new Vector(2);
                        result.add("Data with id " + selected + " not found.  Maybe due to response timeout or conection closed.");
                        result.add("Data with id " + selected + " not found.  Maybe due to response timeout or conection closed.");
                        DumpFrame.this.setResponse(result);
                    }
                } else if (DumpFrame.this.jTabbedPane1.getSelectedIndex() == DumpFrame.this.jTabbedPane1.indexOfTab("Comment") || DumpFrame.this.jTabbedPane1.getSelectedIndex() == DumpFrame.this.jTabbedPane1.indexOfTab("Script")) {
                    result = DumpFrame.this.da.searchResponse(selected);
                    if (result != null) {
                        DumpFrame.this.setComment(result.get(1).toString());
                    } else {
                        DumpFrame.this.setComment(null);
                    }
                }
            }
        });
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.getContentPane().add((Component)this.jTopPanel, "North");
        this.getContentPane().add((Component)this.jScrollPane3, "South");
        this.jList1.addListSelectionListener(this);
    }

    private void btnFilterActionPerformed(ActionEvent e, String searchPlace) {
        FilterDialog dialog = new FilterDialog((Frame)this, true, searchPlace);
        Util.centreChild(this, dialog);
        dialog.show();
    }

    public void addTreePath(String s) {
        try {
            ParsedEntity p = new ParsedEntity("", new URI(s), false);
            this.treePanel.addPath(p);
        }
        catch (HttpMalformedHeaderException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void exitForm(WindowEvent evt) {
        this.hide();
    }

    public void setListModel(DefaultListModel m) {
        this.jList1.setModel(m);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            if (this.jList1.getSelectedValue() == null) {
                return;
            }
            String selected = (String)this.jList1.getSelectedValue();
            selected = selected.substring(0, selected.indexOf("---"));
            Vector result = null;
            if (this.jTabbedPane1.getSelectedIndex() == this.jTabbedPane1.indexOfTab("Request")) {
                result = this.da.searchRequest(selected);
                if (result != null) {
                    this.setRequest(result);
                }
            } else if (this.jTabbedPane1.getSelectedIndex() == this.jTabbedPane1.indexOfTab("Response")) {
                result = this.da.searchResponse(selected);
                if (result != null) {
                    this.setResponse(result);
                } else {
                    result = new Vector(2);
                    result.add("Data with id " + selected + " not found.  Maybe due to response timeout or conection closed.");
                    result.add("Data with id " + selected + " not found.  Maybe due to response timeout or conection closed.");
                    this.setResponse(result);
                }
            } else if (this.jTabbedPane1.getSelectedIndex() == this.jTabbedPane1.indexOfTab("Comment") || this.jTabbedPane1.getSelectedIndex() == this.jTabbedPane1.indexOfTab("Script")) {
                result = this.da.searchResponse(selected);
                if (result != null) {
                    this.setComment(result.get(1).toString());
                } else {
                    this.setComment(null);
                }
            }
            Object var3_3 = null;
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean packFrame = false;
        DumpAnalyzerGUI da = new DumpAnalyzerGUI(new Dump());
        DumpFrame frame = new DumpFrame(da, new DefaultListModel());
        if (packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    private void initMenu() {
        this.jMenuFile.setText("File");
        this.jMenuFile.setMnemonic(70);
        this.jMenuFileExit.setText("Close");
        this.jMenuFileExit.setMnemonic(69);
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DumpFrame.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuEdit.setText("Edit");
        this.jMenuEdit.setMnemonic(69);
        this.jMenuEditFind.setText("Find...");
        this.jMenuEditFind.setMnemonic(70);
        this.jMenuEditFind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jMenuEditFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DumpFrame.this.jMenuEditFind_actionPerformed(e);
            }
        });
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuEdit.add(this.jMenuEditFind);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuBar.add(this.jMenuEdit);
        this.setJMenuBar(this.jMenuBar);
    }

    public void jMenuFileOpen_actionPerformed(ActionEvent e) {
        OpenFileDialog d = new OpenFileDialog();
        d.show();
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        this.hide();
    }

    public void jMenuEditFind_actionPerformed(ActionEvent e) {
        FindDialog dialog = Global.findDialog = new FindDialog((Frame)this, false);
        Util.centreChild(this, dialog);
        dialog.show();
    }

    public void refresh(String pattern, String searchPlace) {
        Pattern p = Pattern.compile(pattern);
        this.da.refresh(p, searchPlace);
    }

    class ScanThread
    extends Thread {
        ScanThread() {
        }

        public void run() {
            DumpFrame.this.btnScan.setEnabled(false);
            DumpFrame.this.jList1.setEnabled(false);
            try {
                ScannerOffline scanner = new ScannerOffline();
                scanner.test(DumpFrame.this.da);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            DumpFrame.this.btnScan.setEnabled(true);
            DumpFrame.this.jList1.setEnabled(true);
        }
    }
}

