/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.log;

import com.proofsecure.paros.log.DumpAnalyzer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class GrepDialog
extends JDialog {
    private DumpAnalyzer analyzer = null;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;

    public GrepDialog(Frame parent, boolean modal, DumpAnalyzer da) {
        super(parent, modal);
        this.analyzer = da;
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Extract pattern in the log using Java regular expression");
        this.setModal(false);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GrepDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 0));
        this.jPanel1.setMaximumSize(new Dimension(400, 24));
        this.jPanel1.setMinimumSize(new Dimension(400, 24));
        this.jPanel1.setPreferredSize(new Dimension(400, 24));
        this.jRadioButton1.setText("Request");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (GrepDialog.this.jRadioButton2.isSelected()) {
                    GrepDialog.this.jRadioButton2.setSelected(false);
                }
                GrepDialog.this.jRadioButton1.setSelected(true);
            }
        });
        this.jPanel1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton2.setText("Response");
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (GrepDialog.this.jRadioButton1.isSelected()) {
                    GrepDialog.this.jRadioButton1.setSelected(false);
                }
                GrepDialog.this.jRadioButton2.setSelected(true);
            }
        });
        this.jPanel1.add(this.jRadioButton2);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setMaximumSize(new Dimension(450, 450));
        this.jPanel2.setMinimumSize(new Dimension(450, 450));
        this.jPanel2.setPreferredSize(new Dimension(450, 450));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 0));
        this.jLabel1.setText("Pattern ");
        this.jPanel3.add(this.jLabel1);
        this.jPanel3.add(this.jTextField1);
        this.jButton1.setText("Extract");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GrepDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Vector result;
        if (this.jTextField1.getText() == null || this.jTextField1.getText().equals("")) {
            return;
        }
        Pattern p = null;
        this.jTextArea1.setText(null);
        try {
            p = Pattern.compile(this.jTextField1.getText(), 42);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage());
            return;
        }
        String searchWhere = "request";
        if (this.jRadioButton2.isSelected()) {
            searchWhere = "response";
        }
        if ((result = this.analyzer.listPattern(p, searchWhere)) == null) {
            return;
        }
        String s = "";
        int i = 0;
        while (i < result.size()) {
            String one = (String)result.get(i);
            s = one.endsWith("\r\n") ? String.valueOf(s) + one : String.valueOf(s) + one + "\r\n";
            ++i;
        }
        this.jTextArea1.setText(s);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
    }
}

