/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.scan.AbstractTest;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.util.ThreadPool;

public abstract class AbstractAppTest
extends AbstractTest
implements Runnable {
    protected AbstractAppTest() {
    }

    void startTest(ParsedEntity startEntity) {
        this.mThreadPool = new ThreadPool(Global.scanner.getScannerThread());
        this.scanTree(startEntity);
        this.mThreadPool.waitAllThreadComplete(30000);
    }

    protected void scanTree(ParsedEntity entity) {
        if (this.isSignalStop()) {
            return;
        }
        this.scanOneNode(entity);
        int i = 0;
        while (i < entity.getChildCount()) {
            try {
                this.scanTree((ParsedEntity)entity.getChildAt(i));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void scanOneNode(ParsedEntity entity) {
        if (this.isSignalStop()) {
            return;
        }
        if (entity.isRoot()) {
            return;
        }
        AbstractAppTest test = null;
        try {
            test = this.create();
            test.init(entity);
            Thread t = this.mThreadPool.getFreeThread(test);
            t.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AbstractAppTest create() {
        AbstractAppTest test = null;
        try {
            test = (AbstractAppTest)this.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return test;
    }
}

