/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.scan.AbstractTest;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.util.ThreadPool;
import java.util.Vector;

abstract class AbstractServerTest
extends AbstractTest {
    private Vector mTestCase = null;

    protected AbstractServerTest() {
    }

    void startTest(ParsedEntity entity) {
        this.mThreadPool = new ThreadPool(Global.scanner.getScannerThread());
        this.mTestCase = new Vector();
        if (entity.isRoot()) {
            int i = 0;
            while (i < entity.getChildCount()) {
                try {
                    ParsedEntity child = (ParsedEntity)entity.getChildAt(i);
                    this.init(child);
                    this.scanServer(child);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        } else {
            try {
                this.init(entity);
                this.scanServer(entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mThreadPool.waitAllThreadComplete(30000);
    }

    protected void scanServer(ParsedEntity entity) {
        block7: {
            if (this.isSignalStop()) {
                return;
            }
            try {
                ParsedEntity parent = (ParsedEntity)entity.getParent();
                if (parent != null && parent.isRoot()) {
                    this.scanNode(entity);
                    break block7;
                }
                int i = 0;
                while (i < entity.getChildCount()) {
                    try {
                        this.scanServer((ParsedEntity)entity.getChildAt(i));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void scanNode(ParsedEntity entity) {
        if (entity.isRoot()) {
            return;
        }
        AbstractServerTest test = null;
        while (this.mTestCase.size() > 0 && !this.isSignalStop()) {
            try {
                test = this.getAndRemoveTestCase();
                Thread t = this.mThreadPool.getFreeThread(test);
                t.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void addTestCase(AbstractServerTest test) {
        Vector vector = this.mTestCase;
        synchronized (vector) {
            this.mTestCase.add(test);
        }
    }

    protected AbstractServerTest getAndRemoveTestCase() {
        AbstractServerTest test = null;
        Vector vector = this.mTestCase;
        synchronized (vector) {
            if (this.mTestCase.size() > 0) {
                test = (AbstractServerTest)this.mTestCase.elementAt(0);
                this.mTestCase.removeElementAt(0);
            }
        }
        return test;
    }
}

