/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.scan.AbstractScanner;
import com.proofsecure.paros.scan.AbstractTest;
import com.proofsecure.paros.scan.Analyser;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.util.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ScannerOneRequest
extends AbstractScanner {
    protected static final String CRLF = "\r\n";
    protected static DecimalFormat decFormat = new DecimalFormat("##0.###");

    protected void process() {
    }

    protected void endOfProcess() {
        Global.currentScanner = null;
        Global.scanner.generateAlertReport();
    }

    public ScannerOneRequest() throws Exception {
        Global.currentScanner = this;
        this.removeAllAlert();
    }

    public void test(ParsedEntity p) {
        long startTime = 0L;
        long diffTime = 0L;
        ParsedEntity child = (ParsedEntity)p.getFirstChild();
        HttpRequestHeader header = child.getRequestHeader();
        header.setHeader("If-Modified-Since", null);
        header.setHeader("If-None-Match", null);
        p.setHostName(header.getHostName());
        p.setHostPort(header.getHostPort());
        p.setSecure(header.getSecure());
        child.setHostName(header.getHostName());
        child.setHostPort(header.getHostPort());
        child.setSecure(header.getSecure());
        AbstractScanner.mAnalyser = new Analyser();
        AbstractScanner.mAnalyser.startTest(p);
        Global.scanner.removeAllAlert();
        startTime = System.currentTimeMillis();
        Util.writeOutput("Scanning ...");
        Object test = null;
        Hashtable testlist = Global.scanManager.getHashtable();
        Vector enablelist = Global.scanManager.getDataModel();
        int i = 0;
        Enumeration e = testlist.elements();
        while (e.hasMoreElements() && !this.mIsSignalStop) {
            test = e.nextElement();
            if (((Boolean)((Vector)enablelist.elementAt(i)).elementAt(0)).booleanValue() && test instanceof AbstractTest) {
                this.mTestModel = test;
                this.writeOutput("Testing " + this.mTestModel.getTestName() + "...");
                try {
                    this.mTestModel.startTest(p);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            ++i;
        }
        DecimalFormat decFormat = new DecimalFormat("##0.###");
        diffTime = System.currentTimeMillis() - startTime;
        String diffTimeString = String.valueOf(decFormat.format((double)diffTime / 1000.0)) + "s";
        Util.writeOutput("Scanning completed in " + diffTimeString);
        Util.writeStatus("Done.");
        this.endOfProcess();
    }

    private CharSequence fromFile(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
        return cbuf;
    }

    public static void main(String[] args) {
        try {
            ScannerOneRequest s = new ScannerOneRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

