/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.scan.AbstractAppTest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

class TestObsoleteFile
extends AbstractAppTest {
    private static final String[] staticSuffixList = new String[]{".old", ".OLD", ".Old", ".bak", ".BAK", ".Bak", ".java", ".inc", ".INC", ".Inc"};
    private static String[] staticAppendixList = new String[]{"~"};
    private static final Pattern patternNotFound = Pattern.compile("(\\bNot\\sfound\\b)|(\\b404\\b)", 42);

    public String toString() {
        return "TestObsoleteFile";
    }

    public String getTestName() {
        return "Obsolete Files";
    }

    protected void scan() throws Exception {
        int i = 0;
        while (i < staticSuffixList.length) {
            this.testSuffix(staticSuffixList[i], false);
            this.testSuffix(staticSuffixList[i], true);
            ++i;
        }
        i = 0;
        while (i < staticAppendixList.length) {
            this.testSuffix(staticAppendixList[i], false);
            ++i;
        }
    }

    private void testSuffix(String suffix, boolean replaceSuffix) throws URISyntaxException, IOException {
        int pos;
        URI oldUri = this.getEntity().getURIHostPath();
        String path = oldUri.getPath();
        if (path == null || path.equals("")) {
            return;
        }
        if (replaceSuffix && (pos = path.lastIndexOf(".")) > -1) {
            path = path.substring(0, pos);
        }
        path = String.valueOf(path) + suffix;
        URI uri = new URI(oldUri.getScheme(), null, oldUri.getHost(), oldUri.getPort(), path, null, null);
        this.getRequestHeader().setURI(uri.toString());
        this.writeStatus("ObsoleteFile: " + this.getRequestHeader().getURIHostPath());
        this.sendAndReceive();
        if (!this.isFileExist(this.getEntity(), this.getRequestHeader(), this.getResponseHeader(), this.getResponseBody())) {
            return;
        }
        this.bingo(10002, 1, 2, uri.toString(), "", "");
    }
}

