/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.network.HttpStatusCode;
import com.proofsecure.paros.scan.TestAbstractParam;
import java.io.IOException;
import java.util.regex.Pattern;

class TestParamTamper
extends TestAbstractParam {
    private String[] PARAM_LIST = new String[]{"", "@", "+", "%A", "%1Z", "%", "%00", "|"};
    private static Pattern patternErrorJava1 = Pattern.compile("javax\\.servlet\\.\\S+", 42);
    private static Pattern patternErrorJava2 = Pattern.compile("invoke.+exception|exception.+invoke", 42);
    private static Pattern patternErrorVBScript = Pattern.compile("Microsoft(\\s+|&nbsp)*VBScript(\\s+|&nbsp)+error", 42);
    private static Pattern patternErrorODBC1 = Pattern.compile("Microsoft OLE DB Provider for ODBC Drivers.*error", 42);
    private static Pattern patternErrorODBC2 = Pattern.compile("ODBC.*Drivers.*error", 42);

    TestParamTamper() {
    }

    public String toString() {
        return "TestParamTamper";
    }

    public String getTestName() {
        return "Parameter Tampering";
    }

    protected void check(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {
        String bingoQuery = null;
        String displayURI = null;
        String newQuery = null;
        String resBodyNormal = null;
        boolean pos = false;
        long defaultTimeUsed = 0L;
        long timeUsed = 0L;
        long lastTime = 0L;
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        defaultTimeUsed = System.currentTimeMillis() - lastTime;
        if (this.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        resBodyNormal = this.getResponseBody().toString();
        int i = 0;
        while (i < this.PARAM_LIST.length) {
            bingoQuery = i == 0 ? this.insertQuery(query, insertPos, "") : this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + this.PARAM_LIST[i]);
            this.createMessage(isBody, bingoQuery);
            lastTime = System.currentTimeMillis();
            this.sendAndReceive();
            defaultTimeUsed = System.currentTimeMillis() - lastTime;
            displayURI = this.getRequestHeader().getURIHostPathQuery();
            if (this.checkResult(bingoQuery, resBodyNormal)) {
                return;
            }
            ++i;
        }
    }

    private boolean checkResult(String query, String normalHTTPResponse) {
        StringBuffer sb = new StringBuffer();
        if (this.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(this.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (this.getResponseBody().toString().equals(normalHTTPResponse)) {
            return false;
        }
        if (this.matchBodyPattern(patternErrorJava1, sb) && this.matchBodyPattern(patternErrorJava2, null)) {
            this.bingo(20002, 2, 2, "", query == null || query.length() == 0 ? "[empty]" : query, sb.toString());
            return true;
        }
        if (this.matchBodyPattern(patternErrorVBScript, sb) || this.matchBodyPattern(patternErrorODBC1, sb) || this.matchBodyPattern(patternErrorODBC2, sb)) {
            this.bingo(20002, 2, 1, "", query == null || query.length() == 0 ? "[empty]" : query, sb.toString());
            return true;
        }
        return false;
    }

    protected void scan() throws Exception {
        boolean skip = this.getEntity().mState == 1;
        this.writeStatus("ParameterTampering: " + (skip ? "(skipped) " : "") + this.getRequestHeader().getURIHostPath());
        if (skip) {
            return;
        }
        this.init();
        this.checkUrlOrBody(false, this.myQuery);
        this.checkUrlOrBody(true, this.myReqBody.toString());
    }
}

