/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScheme;

public class AuthState {
    private AuthScheme authScheme = null;
    private boolean preemptive = false;

    public void setPreemptive() {
        if (this.authScheme != null) {
            throw new IllegalStateException("Authentication state already initialized");
        }
        this.authScheme = AuthPolicy.getAuthScheme("basic");
        this.preemptive = true;
    }

    public void invalidate() {
        this.authScheme = null;
        this.preemptive = false;
    }

    public boolean isPreemptive() {
        return this.preemptive;
    }

    public void setAuthScheme(AuthScheme authScheme) {
        this.authScheme = authScheme;
        this.preemptive = false;
    }

    public AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public String getRealm() {
        if (this.authScheme != null) {
            return this.authScheme.getRealm();
        }
        return null;
    }
}

