/*
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros;

import java.util.Hashtable;

import org.parosproxy.paros.network.HttpSender;


/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class CommandLine {

    private static final String NO_USER_AGENT = "-nouseragent";
    
    private static final String SESSION = "-session";
    private static final String POLICY = "-policy";
    
    private Hashtable hash = new Hashtable();
    private boolean GUI = true;
    
    public CommandLine(String[] args) throws Exception {
        parse(args);
    }
    
    private boolean checkPair(String[] args, String paramName, int i) throws Exception {
        String key = args[i];
        String value = null;
        if (key == null) return false;
        if (key.equalsIgnoreCase(paramName)) {
            value = args[i+1];
            if (value == null) throw new Exception();
            args[i] = null;
            args[i+1] = null;
            hash.put(key, value);
            return true;
        }
        return false;
    }

    private boolean checkSwitch(String[] args, String paramName, int i) throws Exception {
        String key = args[i];
        if (key == null) return false;
        if (key.equalsIgnoreCase(paramName)) {
            args[i] = null;
            hash.put(key, new Boolean(true));
            return true;
        }
        return false;
    }

    
	private void parse(String[] args) throws Exception {
	    String param = "";
	    for (int i=0; i<args.length; i++) {
	        if (checkPair(args, SESSION, i)) {
	            setGUI(false);
	        } else if (checkPair(args, POLICY, i)) {
	            setGUI(false);
	        } else if (checkSwitch(args, NO_USER_AGENT, i)) {
	            HttpSender.setUserAgent("");
	        }
	        
        }
	        
        for (int i=0; i<args.length; i++) {
            if (args[i] != null) {
                throw new Exception();
            }
        }
	        
    }

    /**
     * @return Returns the noGUI.
     */
    public boolean isGUI() {
        return GUI;
    }
    /**
     * @param noGUI The noGUI to set.
     */
    public void setGUI(boolean GUI) {
        this.GUI = GUI;
    }
    /**
     * @return Returns the hash.
     */
    public Hashtable getHashTable() {
        return hash;
    }
}
