/*
 * Created on May 18, 2004
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros;

/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public final class Constant {
	public static final String PROGRAM_NAME 	= "Paros";
	public static final String PROGRAM_VERSION = "3.2.0alpha";
	public static final String PROGRAM_TITLE = PROGRAM_NAME + " " + PROGRAM_VERSION;
	
	public static final String FILE_OPTIONS = "xml/options.xml";
	public static final String FOLDER_PLUGIN = "plugin";
	public static final String FOLDER_FILTER = "filter";
	public static final String FOLDER_SESSION = "session";
    public static final String DBNAME_TEMPLATE = "db/parosdb";
	public static final String DBNAME_UNTITLED = FOLDER_SESSION + "/untitled";

	public static final int MAX_HOST_CONNECTION = 5;
	public static final String USER_AGENT = PROGRAM_NAME + "/" + PROGRAM_VERSION;

	private static String staticEyeCatcher = PROGRAM_NAME;

	public static String getEyeCatcher() {
	    return staticEyeCatcher;
	}
	
	public static void setEyeCatcher(String eyeCatcher) {
	    staticEyeCatcher = eyeCatcher;
	}

	

	
}
