/*
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.extension.report;

import java.awt.EventQueue;
import java.sql.SQLException;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordScan;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ExtensionReport extends ExtensionAdaptor {

	private ExtensionHookMenu pluginMenu = null;
	private SiteMap siteTree = null;
	
	private JMenu menuReport = null;
	private JMenuItem menuItemLastScanReport = null;
	
    /**
     * 
     */
    public ExtensionReport() {
        super();
 		initialize();
    }

    /**
     * @param name
     */
    public ExtensionReport(String name) {
        super(name);
    }

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
        this.setName("ExtensionReport");
			
	}
	public void hook(ExtensionHook extensionHook) {
	    super.hook(extensionHook);
	    extensionHook.getHookMenu().addNewMenu(getMenuReport());
	}
	
	
	/**
	 * This method initializes menuReport	
	 * 	
	 * @return javax.swing.JMenu	
	 */    
	private JMenu getMenuReport() {
		if (menuReport == null) {
			menuReport = new JMenu();
			menuReport.setText("Report");
			menuReport.add(getMenuItemLastScanReport());
			menuReport.addSeparator();
		}
		return menuReport;
	}


	
    /* (non-Javadoc)
     * @see com.proofsecure.paros.core.scanner.ScannerListener#ScannerProgress(java.lang.String, com.proofsecure.paros.network.HttpMessage, int)
     */
	/**
	 * This method initializes menuItemLastScanReport	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */    
	private JMenuItem getMenuItemLastScanReport() {
		if (menuItemLastScanReport == null) {
			menuItemLastScanReport = new JMenuItem();
			menuItemLastScanReport.setText("Last Scan Report");
			menuItemLastScanReport.addActionListener(new java.awt.event.ActionListener() { 

				public void actionPerformed(java.awt.event.ActionEvent e) {    

				    ReportLastScan report = new ReportLastScan();
				    report.generate(getView(), getModel());
	                
				}
			});

		}
		return menuItemLastScanReport;
	}

	
      }
