/*
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.extension.spider;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;

import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;

/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class SpiderDialog extends AbstractDialog implements TreeSelectionListener {

	private JPanel jPanel = null;
	private JTextField txtDisplay = null;
	private JButton btnStart = null;
	private JButton btnStop = null;
	
	private ExtensionSpider extension = null;
	
	private JProgressBar progressBar = null;
    /**
     * @throws HeadlessException
     */
    public SpiderDialog() throws HeadlessException  {
        super();
 		initialize();
    }

    /**
     * @param arg0
     * @param arg1
     * @throws HeadlessException
     */
    public SpiderDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        initialize();
    }

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
        this.setTitle("Spider");
        this.setContentPane(getJPanel());
        this.setSize(397, 223);
        this.addWindowListener(new java.awt.event.WindowAdapter() {   
        	public void windowOpened(java.awt.event.WindowEvent e) {    
        	    extension.getMenuItemSpider().setEnabled(false);
                extension.getPopupMenuSpider().setEnabled(false);
        	} 

        	public void windowClosing(java.awt.event.WindowEvent e) {    

        	    btnStop.doClick();
                extension.getView().getSiteTreePanel().getTreeSite().removeTreeSelectionListener(SpiderDialog.this);
        	    extension.getMenuItemSpider().setEnabled(true);
                extension.getPopupMenuSpider().setEnabled(true);

        	}
        });

			
	}
	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getJPanel() {
		if (jPanel == null) {
			java.awt.GridBagConstraints gridBagConstraints13 = new GridBagConstraints();

			javax.swing.JLabel jLabel2 = new JLabel();

			java.awt.GridBagConstraints gridBagConstraints12 = new GridBagConstraints();

			javax.swing.JLabel jLabel1 = new JLabel();

			java.awt.GridBagConstraints gridBagConstraints11 = new GridBagConstraints();

			java.awt.GridBagConstraints gridBagConstraints4 = new GridBagConstraints();

			javax.swing.JLabel jLabel = new JLabel();

			java.awt.GridBagConstraints gridBagConstraints3 = new GridBagConstraints();

			java.awt.GridBagConstraints gridBagConstraints2 = new GridBagConstraints();

			java.awt.GridBagConstraints gridBagConstraints1 = new GridBagConstraints();

			jPanel = new JPanel();
			jPanel.setLayout(new GridBagLayout());
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 1;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
			gridBagConstraints1.insets = new java.awt.Insets(2,5,5,5);
			gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;
			gridBagConstraints1.gridwidth = 3;
			gridBagConstraints1.ipadx = 3;
			gridBagConstraints1.ipady = 15;
			gridBagConstraints2.gridx = 1;
			gridBagConstraints2.gridy = 4;
			gridBagConstraints2.insets = new java.awt.Insets(2,2,2,2);
			gridBagConstraints2.anchor = java.awt.GridBagConstraints.EAST;
			gridBagConstraints3.gridx = 2;
			gridBagConstraints3.gridy = 4;
			gridBagConstraints3.insets = new java.awt.Insets(2,2,2,5);
			gridBagConstraints3.anchor = java.awt.GridBagConstraints.EAST;
			jLabel.setText("<html><body><p>The site/folder/URL chosen will be crawled.  You may press stop and resume the crawl afterwards.  The spider will crawl hyperlinks and attempt to submit forms.</p></body></html>");
			gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
			gridBagConstraints4.gridx = 0;
			gridBagConstraints4.gridy = 3;
			gridBagConstraints4.fill = java.awt.GridBagConstraints.HORIZONTAL;
			gridBagConstraints4.weightx = 1.0D;
			gridBagConstraints4.insets = new java.awt.Insets(2,5,2,5);
			gridBagConstraints4.gridwidth = 3;
			gridBagConstraints4.ipady = 10;
			gridBagConstraints11.anchor = java.awt.GridBagConstraints.NORTHWEST;
			gridBagConstraints11.fill = java.awt.GridBagConstraints.HORIZONTAL;
			gridBagConstraints11.gridx = 0;
			gridBagConstraints11.gridy = 2;
			gridBagConstraints11.insets = new java.awt.Insets(2,5,10,5);
			gridBagConstraints11.gridwidth = 3;
			jLabel1.setText("URL crawling:");
			gridBagConstraints12.anchor = java.awt.GridBagConstraints.NORTHWEST;
			gridBagConstraints12.fill = java.awt.GridBagConstraints.HORIZONTAL;
			gridBagConstraints12.gridx = 0;
			gridBagConstraints12.gridy = 0;
			gridBagConstraints12.insets = new java.awt.Insets(2,5,2,5);
			gridBagConstraints12.weightx = 2.0D;
			gridBagConstraints12.gridwidth = 3;
			gridBagConstraints12.ipadx = 0;
			gridBagConstraints12.ipady = 0;
			jLabel2.setText(" ");
			gridBagConstraints13.gridx = 0;
			gridBagConstraints13.gridy = 4;
			gridBagConstraints13.fill = java.awt.GridBagConstraints.HORIZONTAL;
			gridBagConstraints13.weightx = 1.0D;
			gridBagConstraints13.insets = new java.awt.Insets(2,5,2,5);
			jPanel.add(jLabel1, gridBagConstraints12);
			jPanel.add(getTxtDisplay(), gridBagConstraints1);
			jPanel.add(getProgressBar(), gridBagConstraints11);
			jPanel.add(jLabel, gridBagConstraints4);
			jPanel.add(jLabel2, gridBagConstraints13);
			jPanel.add(getBtnStart(), gridBagConstraints2);
			jPanel.add(getBtnStop(), gridBagConstraints3);
		}
		return jPanel;
	}
	/**
	 * This method initializes txtDisplay	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	JTextField getTxtDisplay() {
		if (txtDisplay == null) {
			txtDisplay = new JTextField();
			txtDisplay.setEditable(false);
			txtDisplay.setBorder(javax.swing.BorderFactory.createEmptyBorder(0,0,0,0));
			txtDisplay.setHorizontalAlignment(javax.swing.JTextField.LEFT);
			txtDisplay.setAlignmentX(0.0F);
			txtDisplay.setPreferredSize(new java.awt.Dimension(0,26));
		}
		return txtDisplay;
	}
	/**
	 * This method initializes btnStart	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getBtnStart() {
		if (btnStart == null) {
			btnStart = new JButton();
			btnStart.setText("Start");
			btnStart.addActionListener(new java.awt.event.ActionListener() { 

				public void actionPerformed(java.awt.event.ActionEvent e) {
	                extension.getView().getSiteTreePanel().getTreeSite().removeTreeSelectionListener(SpiderDialog.this);
				    btnStart.setEnabled(false);
				    btnStop.setEnabled(true);
				    extension.startSpider();
				    

				}
			});

		}
		return btnStart;
	}
	/**
	 * This method initializes btnStop	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getBtnStop() {
		if (btnStop == null) {
			btnStop = new JButton();
			btnStop.setText("Stop");
			btnStop.setEnabled(false);
			btnStop.addActionListener(new java.awt.event.ActionListener() { 

				public void actionPerformed(java.awt.event.ActionEvent e) {    

				    if (extension.getSpider() != null) {
				        extension.getSpider().stop();
				    }
				    btnStop.setEnabled(false);
				    btnStart.setText("Resume");
				    btnStart.setEnabled(true);

				}
			});

		}
		return btnStop;
	}
	
	void setPlugin(ExtensionSpider plugin) {
	    this.extension = plugin;
        plugin.getView().getSiteTreePanel().getTreeSite().addTreeSelectionListener(this);

	}
	/**
	 * This method initializes progressBar	
	 * 	
	 * @return javax.swing.JProgressBar	
	 */    
	JProgressBar getProgressBar() {
		if (progressBar == null) {
			progressBar = new JProgressBar();
			progressBar.setStringPainted(true);
		}
		return progressBar;
	}
	
	public void valueChanged(javax.swing.event.TreeSelectionEvent e) {
	    JTree siteTree = extension.getView().getSiteTreePanel().getTreeSite();
	    SiteNode node = (SiteNode) siteTree.getLastSelectedPathComponent();
	    extension.setStartNode(node);
        if (node.isRoot()) {
            getTxtDisplay().setText("All sites will be crawled");
        } else {
            HttpMessage msg = (HttpMessage) node.getUserObject();
            if (msg != null) {
                String tmp = msg.getRequestHeader().getURI().toString();
                getTxtDisplay().setText(tmp);
                getTxtDisplay().setCaretPosition(0);
                
            }

		}
	}
	
     }  //  @jve:decl-index=0:visual-constraint="10,10"
