/*
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.model;

import java.sql.SQLException;

import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;


/**
 * 
 * This class abstracts a reference to a http message stored in database.
 * It read the whole http message from database when getHttpMessage() is called.
 */
public class HistoryReference {

    /**
     * Temporary type = not retrieved from history.  To be deleted.
     */
    public static final int TYPE_TEMPORARY = 0;
    public static final int TYPE_MANUAL = 1;
    public static final int TYPE_SPIDER = 2;
    public static final int TYPE_SCANNER = 3;
    // -ve means unsaved message;
    public static final int TYPE_SPIDER_UNSAVE = -TYPE_SPIDER;
    
	private int historyId = 0;
	private int historyType = TYPE_MANUAL;
	private String display = "";
	private static TableHistory staticTableHistory = null;
	
	public HistoryReference(int historyId) throws HttpMalformedHeaderException, SQLException {
		RecordHistory history = null;		
		history = staticTableHistory.read(historyId);
		build(history.getHistoryId(), history.getHistoryType(), history.getHttpMessage());
	    
	}
	
	//public HistoryReference(int historyId, int historyType, HttpMessage msg) {
	//	super();
	//	build(historyId, historyType, msg);
	//}
	
	public HistoryReference(Session session, int historyType, HttpMessage msg) throws HttpMalformedHeaderException, SQLException {
		RecordHistory history = null;		
		history = staticTableHistory.write(session.getSessionId(), historyType, msg);		
		build(history.getHistoryId(), history.getHistoryType(), msg);
		
	}

	private void build(int historyId, int historyType, HttpMessage msg) {
	    StringBuffer sb = new StringBuffer(Integer.toString(historyId) + " ");
	    sb.append(msg.getRequestHeader().getPrimeHeader());
	    if (!msg.getResponseHeader().isEmpty()) {
	        sb.append("  =>  " + msg.getResponseHeader().getPrimeHeader());
	    }
	    this.display =  sb.toString();
		this.historyId = historyId;
		this.historyType = historyType;
	}
	
	public static void setTableHistory(TableHistory tableHistory) {
		staticTableHistory = tableHistory;
	}
	/**
	 * @return Returns the historyId.
	 */
	public int getHistoryId() {
		return historyId;
	}

	public HttpMessage getHttpMessage() throws HttpMalformedHeaderException, SQLException {
		// fetch complete message
		RecordHistory history = staticTableHistory.read(historyId);
		return history.getHttpMessage();
	}
	
	public String toString() {
		return display;
	}
	
    /**
     * @return Returns the historyType.
     */
    public int getHistoryType() {
        return historyType;
    }
}
