/*
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.model;

import org.parosproxy.paros.common.FileXML;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.spider.SpiderParam;
import org.parosproxy.paros.network.ConnectionParam;



/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class OptionsParam extends FileXML {
	
	private static final String ROOT = "Options";
		
	private ProxyParam proxyParam = new ProxyParam();
	private ConnectionParam connectionParam = new ConnectionParam();
	private ScannerParam scannerParam = new ScannerParam();
	private SpiderParam spiderParam = new SpiderParam();
	private ViewParam viewParam = new ViewParam();

	
    /**
     * @return Returns the connectionParam.
     */
    public ConnectionParam getConnectionParam() {
        return connectionParam;
    }
	/**
	 * @return Returns the proxyParam.
	 */
	public ProxyParam getProxyParam() {
		return proxyParam;
	}
	/**
	 * @param proxyParam The proxyParam to set.
	 */
	public void setProxyParam(ProxyParam proxyParam) {
		this.proxyParam = proxyParam;
	}
	public OptionsParam() {
		super(ROOT);
	}
	
	protected void parse() throws Exception {
		getProxyParam().setDocument(doc);
		getConnectionParam().setDocument(doc);
		getScannerParam().setDocument(doc);
		getSpiderParam().setDocument(doc);
		getViewParam().setDocument(doc);

	}


    /**
     * @param connectionParam The connectionParam to set.
     */
    public void setConnectionParam(ConnectionParam connectionParam) {
        this.connectionParam = connectionParam;
    }
    /**
     * @return Returns the scannerParam.
     */
    public ScannerParam getScannerParam() {
        return scannerParam;
    }
    /**
     * @param scannerParam The scannerParam to set.
     */
    public void setScannerParam(ScannerParam scannerParam) {
        this.scannerParam = scannerParam;
    }
    
    /**
     * @param spiderParam The spiderParam to set.
     */
    public void setSpiderParam(SpiderParam spiderParam) {
        this.spiderParam = spiderParam;
    }
    
    /**
     * @return Returns the spiderParam.
     */
    public SpiderParam getSpiderParam() {
        return spiderParam;
    }
    
    /**
     * @param spiderParam The spiderParam to set.
     */
    public void setViewParam(ViewParam viewParam) {
        this.viewParam = viewParam;
    }
    
    /**
     * @return Returns the spiderParam.
     */
    public ViewParam getViewParam() {
        return viewParam;
    }
}

