/*
 * Created on Jun 14, 2004
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.network;

import java.io.UnsupportedEncodingException;

/**
 * Abstract a HTTP body in request or response messages.
 */
public class HttpBody implements java.io.Serializable{

	private StringBuffer body = null;
	private static final String CODEPAGE = "8859_1";
	
	public HttpBody() {
	    body = new StringBuffer();
	}

	/**
	 *	Preallocate HttpBody of a certain size.  A maximum of 256K is fixed to avoid overwhelming
	 * 	by incorrect contentlength.
	 */
	public HttpBody(int capacity) {
	    
	    if (capacity>0) {
	        if (capacity > 128000) {
	            capacity = 128000;
	        }
	        body = new StringBuffer(capacity);
	    } else {
	        body = new StringBuffer();
	    }
	}
	
	/**
	 * Construct a HttpBody from a String.
	 * @param data
	 */
	public HttpBody(String data) {
	    this();
		if (data == null)
			return;
		body.append(data);
	}

	/**
	 * Set this HttpBody to store the data supplied.
	 * @param data
	 */
	public void setBody(String data) {
		body.setLength(0);
		body.append(data);
	}

	/**
	 * Append a byte array with certain length to this body.
	 * @param buf
	 * @param len
	 */
	public void append(byte[] buf, int len) {
		if (buf == null)
			return;
		
		String temp = null;
		try {
			temp = new String(buf, 0, len, CODEPAGE);
		} catch (Exception e) {
			temp = new String(buf, 0, len);
		}
		body.append(temp);
	}
	
	/**
	 * Append a byte array to this body.
	 * @param buf
	 */
	public void append(byte[] buf) {
		if (buf == null)
			return;
		append(buf, buf.length);
	}

	/**
	 * Append a String to this body.
	 * @param buf
	 */
	public void append(String buf) {
		if (buf == null)
			return;
		body.append(buf);
	}

	/**
	 * Get the content of the body as String.
	 */
	public String toString() {
		return body.toString();
	}
	
	public byte[] getBytes() {
		byte[] result = null;
		try {
			result = body.toString().getBytes(CODEPAGE);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return result;
	}

	/**
	 * Current length of the body.
	 * @return
	 */
	public int length() {
		return body.length();
	}

	/**
	 * Set the current length of this body.  If the current content is
	 * longer, the excessive data will be truncated.
	 * @param length
	 */
	public void setLength(int length) {
		body.setLength(length);
	}
}