/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.common;

public class ThreadPool {
    private Thread[] pool = null;

    public ThreadPool(int n) {
        this.pool = new Thread[n];
    }

    public synchronized Thread getFreeThread(Runnable runnable) {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] != null && this.pool[i].isAlive()) continue;
            this.pool[i] = new Thread(runnable);
            this.pool[i].setDaemon(true);
            return this.pool[i];
        }
        return null;
    }

    public void waitAllThreadComplete(int n) {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] == null || !this.pool[i].isAlive()) continue;
            try {
                this.pool[i].join(n);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

