/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;

public class MenuFileControl {
    private static Log log = LogFactory.getLog(class$org$parosproxy$paros$control$MenuFileControl == null ? (class$org$parosproxy$paros$control$MenuFileControl = MenuFileControl.class$("org.parosproxy.paros.control.MenuFileControl")) : class$org$parosproxy$paros$control$MenuFileControl);
    private View view = null;
    private Model model = null;
    private Control control = null;
    static /* synthetic */ Class class$org$parosproxy$paros$control$MenuFileControl;

    public MenuFileControl(Model model, View view, Control control) {
        this.view = view;
        this.model = model;
        this.control = control;
    }

    public void exit() {
        if (this.model.getSession().isNewState()) {
            if (this.view.showConfirmDialog("The current session is not saved.  Discard?") != 0) {
                return;
            }
            this.model.getSession().discard();
        }
        this.control.shutdown();
        log.info("Paros 3.2.0alpha terminated.");
        System.exit(0);
    }

    public void newSession(boolean bl) throws ClassNotFoundException, Exception {
        if (bl) {
            if (this.model.getSession().isNewState()) {
                if (this.view.showConfirmDialog("The current session is not saved.  Discard and create new session?") != 0) {
                    return;
                }
                this.model.getSession().discard();
            } else if (this.view.showConfirmDialog("The current session will be closed.  Create new session?") != 0) {
                return;
            }
            this.model.createAndOpenUntitledDb();
        }
        Session session = new Session(this.model);
        log.info("new session file created");
        this.model.setSession(session);
        this.view.getSiteTreePanel().getTreeSite().setModel(session.getSiteTree());
        if (bl) {
            SessionDialog sessionDialog = this.view.getSessionDialog("New Session");
            sessionDialog.initParam(session);
            sessionDialog.showDialog(false);
            this.saveAsSession();
        }
        this.control.getExtensionLoader().sessionChangedAllPlugin(session);
        this.view.getMainFrame().setTitle("Paros 3.2.0alpha - " + session.getSessionName());
    }

    public void openSession() {
        JFileChooser jFileChooser = new JFileChooser();
        File file = null;
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".session");
            }

            public String getDescription() {
                return "Paros session";
            }
        });
        int n = jFileChooser.showOpenDialog(this.view.getMainFrame());
        if (n == 0) {
            try {
                file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                Session session = this.model.getSession();
                session.open(file.getAbsolutePath());
                log.info("opening session file " + file.getAbsolutePath());
                this.control.getExtensionLoader().sessionChangedAllPlugin(session);
                this.view.getMainFrame().setTitle("Paros - " + this.model.getSession().getSessionName());
            }
            catch (Exception exception) {
                this.view.showWarningDialog("Error opening session file");
                log.error("error opening session file " + file.getAbsolutePath());
                log.error(exception.getMessage());
            }
        }
    }

    public void saveSession() {
        Session session = this.model.getSession();
        if (session.isNewState()) {
            this.view.showWarningDialog("Please use Save As...");
            return;
        }
        try {
            session.save(session.getFileName());
            log.info("saving session file " + session.getFileName());
        }
        catch (Exception exception) {
            this.view.showWarningDialog("Error saving session file.");
            log.error("error saving session file " + session.getFileName());
            log.error(exception.getMessage());
        }
    }

    public boolean saveAsSession() throws Exception {
        String string;
        Session session = this.model.getSession();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".session");
            }

            public String getDescription() {
                return "Paros session";
            }
        });
        File file = null;
        int n = jFileChooser.showSaveDialog(this.view.getMainFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            if (file == null) {
                return false;
            }
            string = file.getAbsolutePath();
            if (!string.endsWith(".session")) {
                string = string + ".session";
            }
        } else {
            return false;
        }
        session.save(string);
        return true;
    }

    public void properties() {
        SessionDialog sessionDialog = this.view.getSessionDialog("Session Properties");
        sessionDialog.initParam(this.model.getSession());
        sessionDialog.showDialog(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

